/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.morimekta.util.Stringable;

public class Slice
implements Comparable<Slice>,
Stringable {
    protected final byte[] fb;
    protected final int off;
    protected final int len;

    public Slice(byte[] fb, int off, int len) {
        this.fb = fb;
        this.off = off;
        this.len = len;
    }

    public final int length() {
        return this.len;
    }

    @Override
    public final String asString() {
        return new String(this.fb, this.off, this.len, StandardCharsets.UTF_8);
    }

    public final Slice substring(int start, int end) {
        int l;
        if (start < 0 || end > this.len || end < -this.len) {
            throw new IllegalArgumentException();
        }
        int n = l = end < 0 ? this.len - start + end : end - start;
        if (l < 0 || l > this.len - start) {
            throw new IllegalArgumentException();
        }
        return new Slice(this.fb, this.off + start, l);
    }

    public final char charAt(int i) {
        if (i < -this.len || this.len <= i) {
            throw new IllegalArgumentException();
        }
        if (i < 0) {
            i = this.len + i;
        }
        return (char)this.fb[this.off + i];
    }

    public final long parseInteger() {
        int pos = this.off;
        int radix = 10;
        if (this.len > 2 && this.charAt(0) == '0' && this.charAt(1) == 'x') {
            pos += 2;
            radix = 16;
        } else if (this.len > 1 && this.charAt(0) == '0') {
            ++pos;
            radix = 8;
        }
        long res = 0L;
        boolean neg = false;
        if (this.fb[this.off] == 45) {
            neg = true;
            ++pos;
        }
        while (pos < this.off + this.len) {
            res *= (long)radix;
            res += (long)Slice.validate(this.fb[pos], Slice.valueOfHex(this.fb[pos]), radix);
            ++pos;
        }
        return neg ? -res : res;
    }

    public final double parseDouble() {
        return Double.parseDouble(this.asString());
    }

    public boolean strEquals(byte[] a) {
        return this.strEquals(a, 0, a.length);
    }

    public boolean strEquals(byte[] a, int aOff, int aLen) {
        if (aLen != this.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (a[aOff + i] == this.fb[this.off + i]) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(byte ... a) {
        for (int i = 0; i < this.len; ++i) {
            for (byte b : a) {
                if (b != this.fb[this.off + i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(byte[] a) {
        int last_pos = this.off + this.len - a.length;
        block0: for (int pos = this.off; pos <= last_pos; ++pos) {
            for (int a_off = 0; a_off < a.length; ++a_off) {
                if (a[a_off] != this.fb[pos + a_off]) continue block0;
            }
            return true;
        }
        return false;
    }

    public boolean contains(byte a) {
        for (int i = this.off; i < this.off + this.len; ++i) {
            if (this.fb[i] != a) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("slice([%d..%d>/%d)", this.off, this.off + this.len, this.fb.length);
    }

    public int hashCode() {
        return Objects.hash(this.off, this.len);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        return other.fb == this.fb && other.off == this.off && other.len == this.len;
    }

    @Override
    public int compareTo(Slice o) {
        if (o.off != this.off) {
            return Integer.compare(this.off, o.off);
        }
        return Integer.compare(o.len, this.len);
    }

    private static int validate(byte c, int value, int radix) {
        if (value < 0 || value >= radix) {
            if (c < 32 || c == 127) {
                throw new IllegalArgumentException(String.format("Char '0x%02x' not valid value for radix %d", c, radix));
            }
            throw new IllegalArgumentException(String.format("Char '%c' not valid value for radix %d", Character.valueOf((char)c), radix));
        }
        return value;
    }

    private static int valueOfHex(byte b) {
        if (b <= 57) {
            return b - 48;
        }
        if (b >= 97) {
            return b - 97 + 10;
        }
        return b - 65 + 10;
    }
}

