/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import net.morimekta.util.Base64;
import net.morimekta.util.Stringable;

public class Binary
implements Comparable<Binary>,
Stringable,
Serializable {
    private final byte[] bytes;

    public Binary(byte[] bytes) {
        this.bytes = bytes;
    }

    public static Binary wrap(byte[] bytes) {
        return new Binary(bytes);
    }

    public static Binary copy(byte[] bytes) {
        return Binary.copy(bytes, 0, bytes.length);
    }

    public static Binary copy(byte[] bytes, int off, int len) {
        byte[] cpy = new byte[len];
        System.arraycopy(bytes, off, cpy, 0, len);
        return Binary.wrap(cpy);
    }

    public int length() {
        return this.bytes.length;
    }

    public byte[] get() {
        byte[] cpy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, cpy, 0, this.bytes.length);
        return cpy;
    }

    public int get(byte[] into) {
        int len = Math.min(into.length, this.bytes.length);
        System.arraycopy(this.bytes, 0, into, 0, len);
        return len;
    }

    public static Binary fromBase64(String base64) {
        byte[] arr = Base64.decode(base64);
        return new Binary(arr);
    }

    public String toBase64() {
        return Base64.encodeToString(this.bytes);
    }

    public static Binary fromHexString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Illegal hex string length: " + hex.length());
        }
        int len = hex.length() / 2;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            String part = hex.substring(pos, pos + 2);
            out[i] = (byte)Integer.parseInt(part, 16);
        }
        return new Binary(out);
    }

    public String toHexString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.bytes.length; ++i) {
            builder.append(String.format("%02x", this.bytes[i]));
        }
        return builder.toString();
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.get());
    }

    public static Binary read(InputStream in, int len) throws IOException {
        int i;
        byte[] bytes = new byte[len];
        for (int pos = 0; pos < len; pos += i) {
            i = in.read(bytes, pos, len - pos);
            if (i > 0) continue;
            throw new IOException("End of stream before complete buffer read.");
        }
        return Binary.wrap(bytes);
    }

    public int write(OutputStream out) throws IOException {
        out.write(this.bytes);
        return this.bytes.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)o;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public int compareTo(Binary other) {
        int c = Math.min(this.bytes.length, other.bytes.length);
        for (int i = 0; i < c; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return this.bytes[i] > other.bytes[i] ? 1 : -1;
        }
        if (this.bytes.length == other.bytes.length) {
            return 0;
        }
        return this.bytes.length > other.bytes.length ? 1 : -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("binary(");
        for (int n : this.bytes) {
            int i = n < 0 ? 256 + n : n;
            buffer.append(String.format(Locale.ENGLISH, "%02x", i));
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String asString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(this.toBase64()).append("]");
        return buffer.toString();
    }
}

