/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util;

import java.nio.charset.StandardCharsets;

public class Base64 {
    private static final byte EQUALS_SIGN = 61;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, 62, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9};

    private Base64() {
    }

    private static int encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                return 2;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                return 3;
            }
        }
        destination[destOffset] = ALPHABET[inBuff >>> 18];
        destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
        destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
        destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
        return 4;
    }

    public static String encodeToString(byte[] source) {
        return Base64.encodeToString(source, 0, source.length);
    }

    public static String encodeToString(byte[] source, int off, int len) {
        byte[] encoded = Base64.encode(source, off, len);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static byte[] encode(byte[] source, int off, int len) {
        int srcPos;
        if (source == null) {
            throw new NullPointerException("Cannot serialize a null array.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Cannot have negative length: " + len);
        }
        if (off + len > source.length) {
            throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", off, len, source.length));
        }
        if (len == 0) {
            return new byte[0];
        }
        int blocks = len / 3;
        int extra = len % 3;
        int bufLen = blocks * 4 + (extra > 0 ? extra + 1 : 0);
        byte[] dest = new byte[bufLen];
        int destPos = 0;
        int len2 = len - 2;
        for (srcPos = 0; srcPos < len2; srcPos += 3) {
            destPos += Base64.encode3to4(source, srcPos + off, 3, dest, destPos);
        }
        if (srcPos < len) {
            Base64.encode3to4(source, srcPos + off, len - srcPos, dest, destPos);
        }
        return dest;
    }

    public static byte[] encode(byte[] source) {
        return Base64.encode(source, 0, source.length);
    }

    private static int decode4to3(byte[] src, int len, byte[] dest, int offset) {
        if (len == 2 || src[2] == 61 && src[3] == 61) {
            int outBuff = Base64.validate(src[0]) << 18 | Base64.validate(src[1]) << 12;
            dest[offset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (len == 3 || src[3] == 61) {
            int outBuff = Base64.validate(src[0]) << 18 | Base64.validate(src[1]) << 12 | Base64.validate(src[2]) << 6;
            dest[offset] = (byte)(outBuff >>> 16);
            dest[offset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = Base64.validate(src[0]) << 18 | Base64.validate(src[1]) << 12 | Base64.validate(src[2]) << 6 | Base64.validate(src[3]);
        dest[offset] = (byte)(outBuff >>> 16);
        dest[offset + 1] = (byte)(outBuff >>> 8);
        dest[offset + 2] = (byte)outBuff;
        return 3;
    }

    private static int validate(byte from) {
        byte b = DECODABET[from & 0x7F];
        if (b < 0) {
            throw new IllegalArgumentException(String.format("Invalid base64 character \\u%04x", from));
        }
        return b;
    }

    public static byte[] decode(byte[] source) {
        return Base64.decode(source, 0, source.length);
    }

    public static byte[] decode(byte[] source, int off, int len) {
        if (source == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Cannot have negative length: " + len);
        }
        if (off + len > source.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and process %d bytes.", source.length, off, len));
        }
        if (len == 0) {
            return new byte[0];
        }
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        for (int i = off; i < off + len; ++i) {
            byte sbiDecode = DECODABET[source[i] & 0x7F];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = source[i];
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 4, outBuff, outBuffPosn);
                b4Posn = 0;
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad Base64 input character decimal %d in array position %d", source[i] & 0xFF, i));
        }
        if (b4Posn > 0) {
            outBuffPosn += Base64.decode4to3(b4, b4Posn, outBuff, outBuffPosn);
        }
        if (outBuffPosn < outBuff.length) {
            byte[] out = new byte[outBuffPosn];
            System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
            return out;
        }
        return outBuff;
    }

    public static byte[] decode(String s) {
        if (s == null) {
            throw new NullPointerException("Input string was null.");
        }
        byte[] bytes = s.getBytes(StandardCharsets.US_ASCII);
        return Base64.decode(bytes, 0, bytes.length);
    }
}

