/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.ServiceMethod;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.StructType;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.util.ConstProvider;
import net.morimekta.providence.reflect.util.TypeRegistry;

public class DocumentConverter {
    private final TypeRegistry registry;

    public DocumentConverter(TypeRegistry registry) {
        this.registry = registry;
    }

    public CDocument convert(ThriftDocument document) {
        ImmutableList.Builder declaredTypes = ImmutableList.builder();
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableMap.Builder<String, String> typedefs = ImmutableMap.builder();
        ImmutableList.Builder services = ImmutableList.builder();
        for (Declaration decl : document.getDecl()) {
            switch (decl.unionField()) {
                case DECL_ENUM: {
                    EnumType enumType = decl.getDeclEnum();
                    int nextValue = 0;
                    Object type = new CEnumDescriptor(enumType.getComment(), document.getPackage(), enumType.getName(), enumType.getAnnotations());
                    LinkedList<CEnumValue> values = new LinkedList<CEnumValue>();
                    for (EnumValue enumValue : enumType.getValues()) {
                        int v = enumValue.hasValue() ? enumValue.getValue() : nextValue;
                        nextValue = v + 1;
                        values.add(new CEnumValue(enumValue.getComment(), enumValue.getValue(), enumValue.getName(), (PEnumDescriptor<CEnumValue>)type, enumValue.getAnnotations()));
                    }
                    ((CEnumDescriptor)type).setValues(values);
                    declaredTypes.add(type);
                    this.registry.putDeclaredType(type);
                    break;
                }
                case DECL_STRUCT: {
                    Object type;
                    StructType structType = decl.getDeclStruct();
                    LinkedList<CField> fields = new LinkedList<CField>();
                    if (structType.hasFields()) {
                        fields.addAll(structType.getFields().stream().map(field -> this.makeField(document.getPackage(), (ThriftField)field)).collect(Collectors.toList()));
                    }
                    switch (structType.getVariant()) {
                        case STRUCT: {
                            type = new CStructDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        case UNION: {
                            type = new CUnionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        case EXCEPTION: {
                            type = new CExceptionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled struct type " + structType.getVariant());
                        }
                    }
                    declaredTypes.add(type);
                    this.registry.putDeclaredType(type);
                    break;
                }
                case DECL_CONST: {
                    ThriftField constant = decl.getDeclConst();
                    constants.add(this.makeField(document.getPackage(), constant));
                    break;
                }
                case DECL_TYPEDEF: {
                    typedefs.put(decl.getDeclTypedef().getName(), decl.getDeclTypedef().getType());
                    this.registry.putTypedef(decl.getDeclTypedef().getType(), decl.getDeclTypedef().getName());
                    break;
                }
                case DECL_SERVICE: {
                    ServiceType serviceType = decl.getDeclService();
                    ImmutableList.Builder methodBuilder = ImmutableList.builder();
                    for (ServiceMethod sm : serviceType.getMethods()) {
                        LinkedList<CField> rqFields = new LinkedList<CField>();
                        if (sm.numParams() > 0) {
                            for (ThriftField field2 : sm.getParams()) {
                                rqFields.add(this.makeField(document.getPackage(), field2));
                            }
                        }
                        CStructDescriptor cStructDescriptor = new CStructDescriptor(null, document.getPackage(), sm.getName() + "___request", rqFields, null);
                        CUnionDescriptor response = null;
                        if (!sm.isOneWay()) {
                            LinkedList<CField> rsFields = new LinkedList<CField>();
                            if (sm.getReturnType() != null) {
                                PDescriptorProvider type = this.registry.getProvider(sm.getReturnType(), document.getPackage(), sm.getAnnotations());
                                CField success = new CField(null, 0, PRequirement.OPTIONAL, "success", type, null, null);
                                rsFields.add(success);
                            }
                            if (sm.numExceptions() > 0) {
                                for (ThriftField field3 : sm.getExceptions()) {
                                    rsFields.add(this.makeField(document.getPackage(), field3));
                                }
                            }
                            response = new CUnionDescriptor(null, document.getPackage(), sm.getName() + "___response", rsFields, null);
                        }
                        CServiceMethod method = new CServiceMethod(sm.getComment(), sm.getName(), sm.isOneWay(), cStructDescriptor, response, sm.getAnnotations());
                        methodBuilder.add(method);
                    }
                    PServiceProvider extendsProvider = null;
                    if (serviceType.hasExtend()) {
                        extendsProvider = this.registry.getServiceProvider(serviceType.getExtend(), document.getPackage());
                    }
                    CService service = new CService(serviceType.getComment(), document.getPackage(), serviceType.getName(), extendsProvider, methodBuilder.build(), serviceType.getAnnotations());
                    services.add(service);
                    this.registry.putService(service);
                }
            }
        }
        return new CDocument(document.getComment(), document.getPackage(), document.getNamespaces(), this.getIncludes(document), typedefs.build(), declaredTypes.build(), services.build(), constants.build());
    }

    private List<String> getIncludes(ThriftDocument document) {
        LinkedList<String> out = new LinkedList<String>();
        for (String include : document.getIncludes()) {
            int i = include.lastIndexOf(46);
            if (i > 0) {
                include = include.substring(0, i);
            }
            out.add(include);
        }
        return out;
    }

    private CField makeField(String pkg, ThriftField field) {
        PDescriptorProvider type = this.registry.getProvider(field.getType(), pkg, field.getAnnotations());
        ConstProvider defaultValue = null;
        if (field.hasDefaultValue()) {
            defaultValue = new ConstProvider(this.registry, field.getType(), pkg, field.getDefaultValue());
        }
        CField made = new CField(field.getComment(), field.getKey(), PRequirement.valueOf(field.getRequirement().getName()), field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }
}

