/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.StructVariant;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.util.Strings;

public class StructType
implements PMessage<StructType, _Field>,
Serializable,
Comparable<StructType> {
    private static final long serialVersionUID = -7531050363059752370L;
    private static final StructVariant kDefaultVariant = StructVariant.STRUCT;
    private final String mComment;
    private final StructVariant mVariant;
    private final String mName;
    private final List<ThriftField> mFields;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<StructType, _Field> kDescriptor = new _Descriptor();

    private StructType(_Builder builder) {
        this.mComment = builder.mComment;
        this.mVariant = builder.mVariant;
        this.mName = builder.mName;
        this.mFields = builder.isSetFields() ? builder.mFields.build() : null;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public StructType(String pComment, StructVariant pVariant, String pName, List<ThriftField> pFields, Map<String, String> pAnnotations) {
        this.mComment = pComment;
        this.mVariant = pVariant;
        this.mName = pName;
        this.mFields = pFields != null ? ImmutableList.copyOf(pFields) : null;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasVariant() {
        return this.mVariant != null;
    }

    public StructVariant getVariant() {
        return this.hasVariant() ? this.mVariant : kDefaultVariant;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public int numFields() {
        return this.mFields != null ? this.mFields.size() : 0;
    }

    public boolean hasFields() {
        return this.mFields != null;
    }

    public List<ThriftField> getFields() {
        return this.mFields;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    @Override
    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return this.hasVariant();
            }
            case 3: {
                return this.hasName();
            }
            case 4: {
                return this.numFields() > 0;
            }
            case 5: {
                return this.numAnnotations() > 0;
            }
        }
        return false;
    }

    @Override
    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return this.hasVariant() ? 1 : 0;
            }
            case 3: {
                return this.hasName() ? 1 : 0;
            }
            case 4: {
                return this.numFields();
            }
            case 5: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    @Override
    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getVariant();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getFields();
            }
            case 5: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    @Override
    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof StructType)) {
            return false;
        }
        StructType other = (StructType)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mVariant, other.mVariant) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mFields, other.mFields) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(StructType.class, _Field.COMMENT, this.mComment, _Field.VARIANT, this.mVariant, _Field.NAME, this.mName, _Field.FIELDS, this.mFields, _Field.ANNOTATIONS, this.mAnnotations);
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.StructType" + this.asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mComment != null) {
            first = false;
            out.append("comment:").append('\"').append(Strings.escape(this.mComment)).append('\"');
        }
        if (this.mVariant != null) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("variant:").append(this.mVariant.toString());
        }
        if (this.mName != null) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("name:").append('\"').append(Strings.escape(this.mName)).append('\"');
        }
        if (this.mFields != null && this.mFields.size() > 0) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("fields:").append(Strings.asString(this.mFields));
        }
        if (this.mAnnotations != null && this.mAnnotations.size() > 0) {
            if (!first) {
                out.append(',');
            }
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(StructType other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mVariant != null, other.mVariant != null);
        if (c != 0) {
            return c;
        }
        if (this.mVariant != null && (c = Integer.compare(this.mVariant.getValue(), this.mVariant.getValue())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mFields != null, other.mFields != null);
        if (c != 0) {
            return c;
        }
        if (this.mFields != null && (c = Integer.compare(this.mFields.hashCode(), other.mFields.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<StructType, _Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<StructType, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    static /* synthetic */ StructVariant access$500() {
        return kDefaultVariant;
    }

    public static class _Builder
    extends PMessageBuilder<StructType, _Field> {
        private BitSet optionals = new BitSet(5);
        private String mComment;
        private StructVariant mVariant;
        private String mName;
        private PList.Builder<ThriftField> mFields = new PList.ImmutableListBuilder<ThriftField>();
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder<String, String>();

        public _Builder() {
        }

        public _Builder(StructType base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            if (base.hasVariant()) {
                this.optionals.set(1);
                this.mVariant = base.mVariant;
            }
            if (base.hasName()) {
                this.optionals.set(2);
                this.mName = base.mName;
            }
            if (base.numFields() > 0) {
                this.optionals.set(3);
                this.mFields.addAll(base.mFields);
            }
            if (base.numAnnotations() > 0) {
                this.optionals.set(4);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        public _Builder merge(StructType from) {
            if (from.hasComment()) {
                this.optionals.set(0);
                this.mComment = from.getComment();
            }
            if (from.hasVariant()) {
                this.optionals.set(1);
                this.mVariant = from.getVariant();
            }
            if (from.hasName()) {
                this.optionals.set(2);
                this.mName = from.getName();
            }
            if (from.hasFields()) {
                this.optionals.set(3);
                this.mFields.clear();
                this.mFields.addAll(from.getFields());
            }
            if (from.hasAnnotations()) {
                this.optionals.set(4);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.clear(0);
            this.mComment = null;
            return this;
        }

        public _Builder setVariant(StructVariant value) {
            this.optionals.set(1);
            this.mVariant = value;
            return this;
        }

        public boolean isSetVariant() {
            return this.optionals.get(1);
        }

        public _Builder clearVariant() {
            this.optionals.clear(1);
            this.mVariant = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(2);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(2);
        }

        public _Builder clearName() {
            this.optionals.clear(2);
            this.mName = null;
            return this;
        }

        public _Builder setFields(Collection<ThriftField> value) {
            this.optionals.set(3);
            this.mFields.clear();
            this.mFields.addAll(value);
            return this;
        }

        public _Builder addToFields(ThriftField ... values) {
            this.optionals.set(3);
            for (ThriftField item : values) {
                this.mFields.add(item);
            }
            return this;
        }

        public boolean isSetFields() {
            return this.optionals.get(3);
        }

        public _Builder clearFields() {
            this.optionals.clear(3);
            this.mFields.clear();
            return this;
        }

        public PList.Builder<ThriftField> mutableFields() {
            return this.mFields;
        }

        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(4);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(4);
            this.mAnnotations.put(key, value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(4);
        }

        public _Builder clearAnnotations() {
            this.optionals.clear(4);
            this.mAnnotations.clear();
            return this;
        }

        public PMap.Builder<String, String> mutableAnnotations() {
            return this.mAnnotations;
        }

        @Override
        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setVariant((StructVariant)value);
                    break;
                }
                case 3: {
                    this.setName((String)value);
                    break;
                }
                case 4: {
                    this.setFields((List)value);
                    break;
                }
                case 5: {
                    this.setAnnotations((Map)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 4: {
                    this.addToFields((ThriftField)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearVariant();
                    break;
                }
                case 3: {
                    this.clearName();
                    break;
                }
                case 4: {
                    this.clearFields();
                    break;
                }
                case 5: {
                    this.clearAnnotations();
                }
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return this.optionals.get(2);
        }

        @Override
        public PStructDescriptor<StructType, _Field> descriptor() {
            return kDescriptor;
        }

        @Override
        public StructType build() {
            return new StructType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<StructType, _Field> {
        private _Factory() {
        }

        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<StructType, _Field> {
        private _Provider() {
        }

        @Override
        public PStructDescriptor<StructType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<StructType, _Field> {
        public _Descriptor() {
            super("model", "StructType", new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", PPrimitive.STRING.provider(), null),
        VARIANT(2, PRequirement.DEFAULT, "variant", StructVariant.provider(), new PDefaultValueProvider<StructVariant>(StructType.access$500())),
        NAME(3, PRequirement.REQUIRED, "name", PPrimitive.STRING.provider(), null),
        FIELDS(4, PRequirement.DEFAULT, "fields", PList.provider(ThriftField.provider()), null),
        ANNOTATIONS(5, PRequirement.DEFAULT, "annotations", PMap.provider(PPrimitive.STRING.provider(), PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        @Override
        public int getKey() {
            return this.mKey;
        }

        @Override
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Override
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Override
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.toString(this);
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return VARIANT;
                }
                case 3: {
                    return NAME;
                }
                case 4: {
                    return FIELDS;
                }
                case 5: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "variant": {
                    return VARIANT;
                }
                case "name": {
                    return NAME;
                }
                case "fields": {
                    return FIELDS;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

