/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.List;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonWriter;

public class ValueBuilder {
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public ValueBuilder(IndentedPrintWriter writer, JHelper helper) {
        this.writer = writer;
        this.helper = helper;
    }

    public void appendDefaultConstants(List<JField> fields) throws GeneratorException {
        boolean hasDefault = false;
        for (JField field : fields) {
            Object defaultValue;
            if (!field.hasDefault() || (defaultValue = this.helper.getDefaultValue(field.getPField())) == null) continue;
            hasDefault = true;
            this.writer.formatln("private final static %s %s = ", field.valueType(), field.kDefault()).begin("        ");
            this.appendTypedValue(defaultValue, field.getPField().getDescriptor());
            this.writer.append(';').end();
        }
        if (hasDefault) {
            this.writer.newline();
        }
    }

    public void appendTypedValue(Object value, PDescriptor type) throws GeneratorException {
        switch (type.getType()) {
            case BOOL: {
                this.writer.append(value.toString());
                break;
            }
            case BYTE: {
                this.writer.append("(byte)").append(value.toString());
                break;
            }
            case I16: {
                this.writer.append("(short)").append(value.toString());
                break;
            }
            case I32: {
                this.writer.append(value.toString());
                break;
            }
            case I64: {
                this.writer.append(value.toString()).append("L");
                break;
            }
            case DOUBLE: {
                this.writer.append(value.toString()).append("d");
                break;
            }
            case BINARY: {
                this.writer.append("Binary.wrap(new byte[]{");
                byte[] bytes = ((Binary)value).get();
                boolean first = true;
                for (byte b : bytes) {
                    if (first) {
                        first = false;
                    } else {
                        this.writer.append(',');
                    }
                    this.writer.format("(byte)%d", b);
                }
                this.writer.append("})");
                break;
            }
            case STRING: {
                try {
                    JsonWriter json = new JsonWriter(this.writer);
                    json.value(value.toString());
                    json.flush();
                    break;
                }
                catch (JsonException je) {
                    throw new GeneratorException("Unable to format string value");
                }
            }
            case ENUM: {
                this.writer.format("%s.%s", this.helper.getValueType(type), JUtils.enumConst((PEnumValue)value));
                break;
            }
            case MESSAGE: {
                this.writer.format("%s.builder()", this.helper.getFieldType(type)).begin();
                PMessage message = (PMessage)value;
                int i = 0;
                for (CField field : ((CStructDescriptor)type).getFields()) {
                    JField fld = new JField(field, this.helper, i++);
                    if (!message.has(field.getKey())) continue;
                    this.writer.formatln(".%s(", fld.setter());
                    this.appendTypedValue(message.get(field.getKey()), field.getDescriptor());
                    this.writer.append(")");
                }
                this.writer.appendln(".build()").end();
                break;
            }
            case MAP: 
            case LIST: 
            case SET: {
                throw new GeneratorException("Collections cannot have default value.");
            }
        }
    }
}

