/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.io.File;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.util.Strings;

public class JUtils {
    public static long generateSerialVersionUID(PStructDescriptor<?, ?> type) {
        String string = type.getVariant().getName() + " " + type.getQualifiedName(null);
        long hash = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            hash = 4909L * hash + 7919L * (long)string.charAt(i);
        }
        return hash;
    }

    public static String getClassName(PDeclaredDescriptor<?> type) {
        return JUtils.camelCase("", type.getName());
    }

    public static String getClassName(PService service) {
        return JUtils.camelCase("", service.getName());
    }

    public static String getJavaPackage(CDocument document) throws GeneratorException {
        String javaPackage = document.getNamespaceForLanguage("java");
        if (javaPackage == null) {
            throw new GeneratorException("No java namespace for thrift package " + document.getPackageName());
        }
        return javaPackage;
    }

    public static String getPackageClassPath(String javaPackage) throws GeneratorException {
        Object[] parts = javaPackage.split("[.]");
        return Strings.join(File.separator, parts);
    }

    public static String camelCase(String name) {
        StringBuilder builder = new StringBuilder();
        String[] parts = name.split("[-._]");
        boolean first = true;
        int skipped = 0;
        for (String part : parts) {
            if (part.isEmpty()) {
                ++skipped;
                continue;
            }
            if (first) {
                first = false;
                builder.append(part);
            } else if (skipped > 1) {
                builder.append('_');
                builder.append(part);
            } else {
                builder.append(Strings.capitalize(part));
            }
            skipped = 0;
        }
        return builder.toString();
    }

    public static String camelCase(String prefix, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        String[] parts = name.split("[-._]");
        int skipped = 0;
        for (String part : parts) {
            if (part.isEmpty()) {
                ++skipped;
                continue;
            }
            if (skipped > 1) {
                builder.append('_');
                builder.append(part);
            } else {
                builder.append(Strings.capitalize(part));
            }
            skipped = 0;
        }
        return builder.toString();
    }

    public static String enumConst(PEnumValue value) {
        return Strings.c_case("", value.getName()).toUpperCase();
    }
}

