/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import java.util.ArrayList;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JUtils;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.util.Strings;

public class JServiceMethod {
    private final CService service;
    private final CServiceMethod method;
    private final JHelper helper;

    public JServiceMethod(CService service, CServiceMethod method, JHelper helper) {
        this.service = service;
        this.method = method;
        this.helper = helper;
    }

    public CServiceMethod getMethod() {
        return this.method;
    }

    public CService getService() {
        return this.service;
    }

    public String constant() {
        return Strings.c_case("", this.method.getName()).toUpperCase();
    }

    public String name() {
        return this.method.getName();
    }

    public String methodName() {
        return JUtils.camelCase(this.method.getName());
    }

    public String getRequestClass() {
        return JUtils.camelCase("", this.method.getRequestType().getName());
    }

    public String getResponseClass() {
        if (this.method.getResponseType() != null) {
            return JUtils.camelCase("", this.method.getResponseType().getName());
        }
        return null;
    }

    public JField getResponse() {
        if (this.method.getResponseType() != null && this.method.getResponseType().getField(0) != null) {
            return new JField(this.method.getResponseType().getField(0), this.helper, 0);
        }
        return null;
    }

    public JField[] params() {
        CField[] fields = this.method.getRequestType().getFields();
        JField[] ret = new JField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ret[i] = new JField(fields[i], this.helper, i);
        }
        return ret;
    }

    public JField[] exceptions() {
        if (this.method.getResponseType() == null) {
            return new JField[0];
        }
        ArrayList<JField> ret = new ArrayList<JField>();
        int idx = 0;
        for (CField field : this.method.getResponseType().getFields()) {
            if (field.getKey() == 0) continue;
            ret.add(new JField(field, this.helper, idx++));
        }
        return ret.toArray(new JField[ret.size()]);
    }
}

