/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.utils;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import net.morimekta.util.io.IndentedPrintWriter;

public class BlockCommentBuilder {
    private final IndentedPrintWriter writer;
    private final Escaper html = HtmlEscapers.htmlEscaper();

    public BlockCommentBuilder(IndentedPrintWriter writer) {
        this.writer = writer;
        writer.appendln("/**").begin(" *");
    }

    public BlockCommentBuilder comment(String comment) {
        String escaped = this.html.escape(comment);
        for (String line : escaped.trim().split("\r?\n")) {
            if (line.length() == 0) {
                this.writer.appendln(" <p>");
                continue;
            }
            this.writer.appendln(" " + line);
        }
        return this;
    }

    public BlockCommentBuilder newline() {
        this.writer.appendln();
        return this;
    }

    public BlockCommentBuilder param_(String name, String comment) {
        this.writer.formatln(" @param %s %s", name, this.html.escape(comment));
        return this;
    }

    public BlockCommentBuilder return_(String comment) {
        this.writer.formatln(" @return %s", this.html.escape(comment));
        return this;
    }

    public BlockCommentBuilder throws_(Class<?> klass, String comment) {
        this.writer.formatln(" @throws %s %s", klass.getName().replaceAll("[$]", "."), this.html.escape(comment));
        return this;
    }

    public BlockCommentBuilder throws_(String klass, String comment) {
        this.writer.formatln(" @throws %s %s", this.html.escape(comment));
        return this;
    }

    public BlockCommentBuilder see_(Class<?> klass, String comment) {
        this.writer.formatln(" @see %s %s", klass.getName().replaceAll("[$]", "."), this.html.escape(comment));
        return this;
    }

    public BlockCommentBuilder see_(String klass, String comment) {
        this.writer.formatln(" @see %s %s", this.html.escape(comment));
        return this;
    }

    public void finish() {
        this.writer.end().appendln(" */");
    }
}

