/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java.tiny;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.tiny.TinyOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;

public class TinyMessageBuilderFormat {
    private final TinyOptions options;
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public TinyMessageBuilderFormat(IndentedPrintWriter writer, JHelper helper, TinyOptions options) {
        this.writer = writer;
        this.helper = helper;
        this.options = options;
    }

    public void appendBuilder(JMessage<?> message) throws GeneratorException {
        this.appendMutators();
        if (this.options.jackson) {
            this.appendJacksonDeserializer(message);
        }
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln("@Deprecated");
        }
        this.writer.appendln("public static class _Builder {").begin();
        this.appendFields(message);
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
        for (JField field : message.fields()) {
            this.appendSetter(message, field);
            this.appendResetter(message, field);
        }
        this.writer.formatln("public %s build() {", message.instanceType()).begin().formatln("return new %s(this);", message.instanceType()).end().appendln('}');
        this.writer.end().appendln('}');
    }

    private void appendReadValue(String builder, JField field, JMessage message) throws GeneratorException {
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.getPField().getDescriptor();
                PDescriptor kType = mType.keyDescriptor();
                this.writer.formatln("%s kType = ctxt.getTypeFactory().uncheckedSimpleType(%s.class);", JavaType.class.getName(), this.helper.getFieldType(kType));
                PDescriptor iType = mType.itemDescriptor();
                if (iType instanceof PMap) {
                    PMap imType = (PMap)iType;
                    PDescriptor ikType = imType.keyDescriptor();
                    PDescriptor iiType = imType.itemDescriptor();
                    if (iiType instanceof PContainer) {
                        throw new GeneratorException("Too many levels of containers: " + field.toString());
                    }
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().constructMapType(%s.class, %s.class, %s.class);", MapType.class.getName(), HashMap.class.getName(), this.helper.getFieldType(ikType), this.helper.getFieldType(iiType));
                } else if (iType instanceof PContainer) {
                    PContainer icType = (PContainer)iType;
                    PDescriptor iiType = icType.itemDescriptor();
                    if (iiType instanceof PContainer) {
                        throw new GeneratorException("Too many levels of containers: " + field.toString());
                    }
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().constructArrayType(%s.class);", MapType.class.getName(), this.helper.getFieldType(iiType));
                } else {
                    this.writer.formatln("%s iType = ctxt.getTypeFactory().uncheckedSimpleType(%s.class);", JavaType.class.getName(), this.helper.getFieldType(iType));
                }
                this.writer.formatln("%s type = ctxt.getTypeFactory().constructMapType(%s.class, kType, iType);", MapType.class.getName(), HashMap.class.getName());
                this.writer.formatln("%s.%s(ctxt.readValue(jp, type));", builder, field.setter());
                break;
            }
            case LIST: {
                PContainer cType = (PContainer)field.getPField().getDescriptor();
                PDescriptor iType = cType.itemDescriptor();
                if (iType instanceof PMap) {
                    PMap imType = (PMap)iType;
                    PDescriptor ikType = imType.keyDescriptor();
                    PDescriptor iiType = imType.itemDescriptor();
                    this.writer.formatln("%s itype = ctxt.getTypeFactory().constructMapType(%s.class, %s.class, %s.class);", MapType.class.getName(), LinkedHashMap.class.getName(), this.helper.getFieldType(ikType), this.helper.getFieldType(iiType));
                    this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(itype);", ArrayType.class.getName(), this.helper.getFieldType(iType));
                } else if (iType instanceof PContainer) {
                    PContainer icType = (PContainer)iType;
                    PDescriptor iiType = icType.itemDescriptor();
                    this.writer.formatln("%s itype = ctxt.getTypeFactory().constructArrayType(%s.class);", ArrayType.class.getName(), this.helper.getFieldType(iiType));
                    this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(itype);", ArrayType.class.getName(), this.helper.getFieldType(iType));
                } else {
                    this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(%s.class);", ArrayType.class.getName(), this.helper.getFieldType(iType));
                }
                this.writer.formatln("%s.%s(ctxt.readValue(jp, type));", builder, field.setter());
                break;
            }
            case SET: {
                PContainer cType = (PContainer)field.getPField().getDescriptor();
                PDescriptor iType = cType.itemDescriptor();
                this.writer.formatln("%s type = ctxt.getTypeFactory().constructArrayType(%s.class);", ArrayType.class.getName(), this.helper.getFieldType(iType));
                this.writer.formatln("%s.%s(ctxt.readValue(jp, type));", builder, field.setter());
                break;
            }
            case BINARY: {
                this.writer.formatln("%s.%s(%s.fromBase64(ctxt.readValue(jp, String.class)));", builder, field.setter(), Binary.class.getName());
                break;
            }
            case STRING: 
            case MESSAGE: 
            case ENUM: {
                this.writer.formatln("%s.%s(ctxt.readValue(jp, %s.class));", builder, field.setter(), field.instanceType());
                break;
            }
            default: {
                this.writer.formatln("%s.%s(ctxt.readValue(jp, %s.TYPE));", builder, field.setter(), field.instanceType());
            }
        }
    }

    private void appendJacksonDeserializer(JMessage<?> message) throws GeneratorException {
        this.writer.formatln("public static class _Deserializer extends %s<%s> {", JsonDeserializer.class.getName(), message.instanceType()).begin();
        this.writer.appendln("@Override").formatln("public %s deserialize(%s jp,", message.instanceType(), JsonParser.class.getName()).formatln("       %s             %s ctxt)", message.instanceType().replaceAll("[\\S]", " "), DeserializationContext.class.getName()).formatln("         throws %s,", IOException.class.getName()).formatln("                %s {", JsonProcessingException.class.getName()).begin();
        this.writer.appendln("_Builder builder = builder();").newline();
        this.writer.formatln("if (jp.isExpectedStartObjectToken()) {", new Object[0]).begin().formatln("while (jp.nextToken() != %s.END_OBJECT) {", JsonToken.class.getName()).begin().formatln("if (jp.getCurrentToken() != %s.FIELD_NAME) {", JsonToken.class.getName()).formatln("    throw new %s(jp, \"Invalid field name token \" + jp.getText());", JsonParseException.class.getName()).appendln('}').newline().appendln("String field = jp.getCurrentName();").appendln("jp.nextToken();").appendln("switch (field) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case \"%d\":", field.id()).formatln("case \"%s\": {", field.name()).begin();
            this.appendReadValue("builder", field, message);
            this.writer.appendln("break;").end().appendln('}');
        }
        this.writer.end().appendln("}").end().appendln("}");
        if (message.descriptor().isCompactible()) {
            this.writer.end().appendln("} else if (jp.isExpectedStartArrayToken()) {").begin();
            this.writer.appendln("int idx = 0;").formatln("while (jp.nextToken() != %s.END_ARRAY) {", JsonToken.class.getName()).begin().appendln("switch (idx++) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %d: {", field.index()).begin();
                this.appendReadValue("builder", field, message);
                this.writer.appendln("break;").end().appendln('}');
            }
            this.writer.appendln("default:").formatln("    throw new %s(jp, \"Unexpected value: \" + jp.getText());", JsonParseException.class.getName()).end().appendln('}').end().appendln('}');
        }
        this.writer.end().appendln("} else {").formatln("    throw new %s(jp, \"Invalid token for object deserialization \" + jp.getText());", JsonParseException.class.getName()).appendln('}').newline().appendln("return builder.build();");
        this.writer.end().formatln("}", new Object[0]).end().formatln("}", new Object[0]).newline();
    }

    private void appendMutators() {
        this.writer.appendln("public _Builder mutate() {").begin().appendln("return new _Builder(this);").end().appendln('}').newline();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln("return new _Builder();").end().appendln('}').newline();
    }

    private void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.appendln("private int tUnionField;");
        }
        this.writer.newline();
        for (JField field : message.fields()) {
            this.writer.formatln("private %s %s;", field.fieldType(), field.member());
        }
        if (message.fields().size() > 0) {
            this.writer.newline();
        }
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").finish();
        this.writer.appendln("public _Builder() {").begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = Integer.MAX_VALUE;", new Object[0]);
        }
        message.fields().stream().filter(JField::hasDefault).forEachOrdered(field -> this.writer.formatln("%s = %s;", field.member(), field.kDefault()));
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a mutating builder off a base " + message.descriptor().getQualifiedName(null) + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", message.instanceType()).begin().appendln("this();").newline();
        if (message.isUnion()) {
            this.writer.appendln("tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.fields()) {
            this.writer.formatln("%s = base.%s;", field.member(), field.member());
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Sets the value of " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.param_("value", "The new value").return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln("@Deprecated");
        }
        if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(%s<%s> value) {", field.setter(), Collection.class.getName(), iType);
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", field.setter(), field.valueType());
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = %s;", field.fieldEnum());
        }
        this.writer.formatln("%s = %s;", field.member(), field.copyOfUnsafe("value"));
        this.writer.appendln("return this;").end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Clears the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The builder").finish();
        this.writer.formatln("public _Builder %s() {", field.resetter()).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == %s) tUnionField = Integer.MAX_VALUE;", field.fieldEnum());
        }
        if (field.hasDefault()) {
            this.writer.formatln("%s = %s;", field.member(), field.kDefault());
        } else {
            this.writer.formatln("%s = null;", field.member());
        }
        this.writer.appendln("return this;").end().appendln('}').newline();
    }
}

