/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.io.IOException;
import net.morimekta.providence.PClient;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JMessageFormat;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.providence.generator.format.java.utils.JService;
import net.morimekta.providence.generator.format.java.utils.JServiceMethod;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CStruct;
import net.morimekta.providence.reflect.contained.CUnion;
import net.morimekta.providence.serializer.ApplicationException;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JServiceFormat {
    private final JHelper helper;
    private final JMessageFormat messageFormat;

    JServiceFormat(JHelper helper, JMessageFormat messageFormat) {
        this.helper = helper;
        this.messageFormat = messageFormat;
    }

    public void format(IndentedPrintWriter writer, CService cs) throws GeneratorException, IOException {
        JService service = new JService(cs, this.helper);
        if (cs.getComment() != null) {
            new BlockCommentBuilder(writer).comment(cs.getComment()).finish();
        }
        writer.appendln("@SuppressWarnings(\"unused\")").formatln("public class %s {", service.className()).begin();
        this.appendIface(writer, service);
        this.appendClient(writer, service);
        this.appendProcessor(writer, service);
        this.appendDescriptor(writer, service);
        this.appendStructs(writer, service);
        writer.formatln("private %s() {}", service.className());
        writer.end().appendln('}');
    }

    private void appendClient(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.appendln("public static class Client").formatln("        extends %s", PClient.class.getName()).formatln("        implements Iface {", new Object[0]).begin();
        writer.formatln("private final %s handler;", PClientHandler.class.getName()).newline();
        writer.formatln("public Client(%s handler) {", PClientHandler.class.getName()).appendln("    this.handler = handler;").appendln('}').newline();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            writer.appendln("@Override");
            JField ret = method.getResponse();
            writer.appendln("public ");
            if (ret != null) {
                writer.append(ret.valueType());
            } else {
                writer.append("void");
            }
            writer.format(" %s(", method.methodName()).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(",");
                }
                writer.formatln("%s %s", param.valueType(), param.param());
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", IOException.class.getName()).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append(",");
                writer.appendln(ex.instanceType());
            }
            writer.format(" {", new Object[0]).end().begin().appendln("try {").begin();
            writer.formatln("%s._Builder rq = %s.builder();", method.getRequestClass(), method.getRequestClass());
            for (JField param : method.params()) {
                writer.formatln("rq.%s(%s);", param.setter(), param.param());
            }
            String type = method.getMethod().isOneway() ? PServiceCallType.ONEWAY.name() : PServiceCallType.CALL.name();
            writer.newline().formatln("%s call = new %s(\"%s\", %s.%s, getNextSequenceId(), rq.build());", PServiceCall.class.getName(), PServiceCall.class.getName(), method.name(), PServiceCallType.class.getName(), type).appendln();
            if (method.getResponseClass() != null) {
                writer.format("%s resp = ", PServiceCall.class.getName());
            }
            writer.format("handler.handleCall(call, %s.kDescriptor);", service.className());
            if (method.getResponseClass() != null) {
                writer.formatln("%s msg = (%s) resp.getMessage();", method.getResponseClass(), method.getResponseClass());
                writer.newline().formatln("if (resp.getType() == %s.%s) {", PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()).formatln("    %s ex = (%s) resp.getMessage();", ApplicationException.class.getName(), ApplicationException.class.getName()).formatln("    throw new %s(ex.getMessage(), ex);", IOException.class.getName()).appendln('}');
                if (method.exceptions().length > 0) {
                    writer.appendln("if (msg.unionField() != null) {").begin();
                    writer.appendln("switch (msg.unionField()) {").begin();
                    for (JField ex : method.exceptions()) {
                        writer.formatln("case %s:", ex.fieldEnum()).formatln("    throw msg.%s();", ex.getter());
                    }
                    writer.end().appendln("}");
                    writer.end().appendln("}");
                }
                if (method.getResponse() != null) {
                    writer.newline().formatln("return msg.%s();", method.getResponse().getter());
                }
            }
            writer.end().formatln("} catch (%s e) {", SerializerException.class.getName()).formatln("    throw new %s(e);", IOException.class.getName()).appendln('}').end().appendln('}');
        }
        writer.end().appendln('}').newline();
    }

    private void appendProcessor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public static class Processor implements %s {", PProcessor.class.getName()).begin().appendln("private final Iface impl;");
        writer.formatln("public Processor(Iface impl) {", new Object[0]).appendln("    this.impl = impl;").appendln('}').newline();
        writer.appendln("@Override").formatln("public boolean process(%s reader, %s writer) throws %s {", MessageReader.class.getName(), MessageWriter.class.getName(), IOException.class.getName()).begin();
        writer.appendln("try {").begin();
        writer.formatln("%s call;", PServiceCall.class.getName()).appendln("try {").formatln("    call = reader.read(%s.kDescriptor);", service.className()).formatln("} catch (%s se) {", SerializerException.class.getName()).formatln("    writer.write(new %s(", PServiceCall.class.getName()).appendln("            se.getMethodName(),").formatln("            %s.%s,", PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()).appendln("            se.getSequenceNo(),").formatln("            new %s(", ApplicationException.class.getName()).appendln("                    se.getMessage(),").appendln("                    se.getExceptionType())));").appendln("    return true;").appendln('}').newline();
        writer.appendln("switch(call.getMethod()) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": {", method.name()).begin();
            if (method.getResponseClass() != null) {
                writer.formatln("%s._Builder rsp = %s.builder();", method.getResponseClass(), method.getResponseClass());
            }
            if (method.exceptions().length > 0) {
                writer.appendln("try {").begin();
            }
            writer.formatln("%s req = (%s) call.getMessage();", method.getRequestClass(), method.getRequestClass());
            String indent = "      " + Strings.times(" ", method.methodName().length());
            if (method.getResponse() != null) {
                writer.formatln("%s result =", method.getResponse().valueType());
                writer.appendln("        ");
                indent = indent + "        ";
            } else {
                writer.appendln();
            }
            writer.format("impl.%s(", method.methodName()).begin(indent);
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').appendln();
                }
                writer.format("req.%s()", param.getter());
            }
            writer.end().append(");");
            if (method.getResponse() != null) {
                writer.formatln("rsp.%s(result);", method.getResponse().setter());
            }
            if (method.exceptions().length > 0) {
                writer.end();
                for (JField ex : method.exceptions()) {
                    writer.formatln("} catch (%s e) {", ex.instanceType()).begin().formatln("rsp.%s(e);", ex.setter()).end();
                }
                writer.appendln('}');
            }
            if (method.getResponseClass() != null) {
                String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
                writer.formatln("%s reply =", PServiceCall.class.getName()).formatln("        new %s(call.getMethod(),", PServiceCall.class.getName()).formatln("            %s %s.%s,", spaces, PServiceCallType.class.getName(), PServiceCallType.REPLY.name()).formatln("            %s call.getSequence(),", spaces).formatln("            %s rsp.build());", spaces).appendln("writer.write(reply);");
            }
            writer.formatln("break;", new Object[0]).end().appendln('}');
        }
        writer.appendln("default: {").begin().formatln("%s ex =", ApplicationException.class.getName()).formatln("        new %s(", ApplicationException.class.getName()).formatln("                \"Unknown method \\\"\" + call.getMethod() + \"\\\" on %s.\",", service.getService().getQualifiedName(null)).formatln("                %s.%s);", ApplicationExceptionType.class.getName(), ApplicationExceptionType.UNKNOWN_METHOD.getName());
        String spaces = PServiceCall.class.getName().replaceAll("[\\S]", " ");
        writer.formatln("%s reply =", PServiceCall.class.getName()).formatln("        new %s(call.getMethod(),", PServiceCall.class.getName()).formatln("            %s %s.%s,", spaces, PServiceCallType.class.getName(), PServiceCallType.EXCEPTION.name()).formatln("            %s call.getSequence(),", spaces).formatln("            %s ex);", spaces).appendln("writer.write(reply);");
        writer.appendln("break;").end().appendln('}').end().appendln('}');
        writer.appendln("return true;").end().formatln("} catch (%s e) {", SerializerException.class.getName()).formatln("    throw new %s(e.getMessage(), e);", IOException.class.getName()).appendln('}').end().appendln('}');
        writer.end().appendln('}').newline();
    }

    private void appendDescriptor(IndentedPrintWriter writer, JService service) throws GeneratorException {
        writer.formatln("public enum Method implements %s {", PServiceMethod.class.getName()).begin();
        for (JServiceMethod method : service.methods()) {
            String responseDesc = method.getResponseClass() == null ? "null" : method.getResponseClass() + ".kDescriptor";
            writer.formatln("%s(\"%s\", %b, %s.kDescriptor, %s),", method.constant(), method.name(), method.getMethod().isOneway(), method.getRequestClass(), responseDesc);
        }
        writer.appendln(';').newline();
        writer.appendln("private final String name;").appendln("private final boolean oneway;").formatln("private final %s request;", PStructDescriptor.class.getName()).formatln("private final %s response;", PUnionDescriptor.class.getName()).newline();
        writer.formatln("private Method(String name, boolean oneway, %s request, %s response) {", PStructDescriptor.class.getName(), PUnionDescriptor.class.getName()).appendln("    this.name = name;").appendln("    this.oneway = oneway;").appendln("    this.request = request;").appendln("    this.response = response;").appendln('}').newline();
        writer.appendln("public String getName() {").appendln("    return name;").appendln('}').newline().appendln("public boolean isOneway() {").appendln("    return oneway;").appendln('}').newline().formatln("public %s getRequestType() {", PStructDescriptor.class.getName()).formatln("    return request;", new Object[0]).appendln('}').newline().formatln("public %s getResponseType() {", PUnionDescriptor.class.getName()).formatln("    return response;", new Object[0]).appendln('}').newline();
        writer.appendln("public static Method forName(String name) {").begin().appendln("switch (name) {").begin();
        for (JServiceMethod method : service.methods()) {
            writer.formatln("case \"%s\": return %s;", method.name(), method.constant());
        }
        writer.end().appendln('}').appendln("return null;").end().appendln('}');
        writer.end().appendln('}').newline();
        String inherits = "null";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = this.helper.getJavaPackage(other) + "." + new JService(other, this.helper).className() + ".kDescriptor";
        }
        writer.formatln("private static class _Descriptor extends %s {", PService.class.getName()).begin().appendln("private _Descriptor() {").formatln("    super(\"%s\", \"%s\", %s, Method.values());", service.getService().getPackageName(), service.getService().getName(), inherits).appendln('}').newline().appendln("@Override").appendln("public Method getMethod(String name) {").appendln("    return Method.forName(name);").appendln("}").end().appendln('}').newline();
        writer.formatln("public static final %s kDescriptor = new _Descriptor();", PService.class.getName()).newline();
    }

    private void appendStructs(IndentedPrintWriter writer, JService service) throws GeneratorException, IOException {
        for (JServiceMethod method : service.methods()) {
            JMessage<CStruct> request = new JMessage<CStruct>(method.getMethod().getRequestType(), this.helper);
            writer.formatln("// type --> %s", request.descriptor().getName());
            this.messageFormat.format(writer, method.getMethod().getRequestType(), service.getService());
            if (method.getMethod().getResponseType() == null) continue;
            JMessage<CUnion> response = new JMessage<CUnion>(method.getMethod().getResponseType(), this.helper);
            writer.formatln("// type <-- %s", response.descriptor().getName());
            this.messageFormat.format(writer, method.getMethod().getResponseType(), service.getService());
        }
    }

    private void appendIface(IndentedPrintWriter writer, JService service) throws GeneratorException {
        String inherits = "";
        if (service.getService().getExtendsService() != null) {
            CService other = (CService)service.getService().getExtendsService();
            inherits = "extends " + this.helper.getJavaPackage(other) + "." + new JService(other, this.helper).className() + ".Iface ";
        }
        writer.formatln("public interface Iface %s{", inherits).begin();
        boolean firstMethod = true;
        for (JServiceMethod method : service.methods()) {
            JField ret;
            if (firstMethod) {
                firstMethod = false;
            } else {
                writer.newline();
            }
            if (method.getMethod().getComment() != null) {
                new BlockCommentBuilder(writer).comment(method.getMethod().getComment()).finish();
            }
            if ((ret = method.getResponse()) != null) {
                writer.appendln(ret.valueType());
            } else {
                writer.appendln("void");
            }
            writer.format(" %s(", method.methodName()).begin("        ");
            boolean first = true;
            for (JField param : method.params()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(",");
                }
                writer.formatln("%s %s", param.valueType(), param.param());
            }
            writer.end().format(")", new Object[0]).formatln("        throws %s", IOException.class.getName()).begin("               ");
            for (JField ex : method.exceptions()) {
                writer.append(",");
                writer.appendln(ex.instanceType());
            }
            writer.format(";", new Object[0]).end();
        }
        writer.end().appendln('}').newline();
    }
}

