/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.Objects;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageOverridesFormat {
    private final IndentedPrintWriter writer;
    private final JOptions options;
    private final JHelper helper;

    public JMessageOverridesFormat(IndentedPrintWriter writer, JOptions options, JHelper helper) {
        this.writer = writer;
        this.options = options;
        this.helper = helper;
    }

    public void appendOverrides(JMessage message) {
        this.appendPresence(message);
        this.appendCounter(message);
        this.appendGetter(message);
        this.appendCompact(message);
        this.appendEquals(message);
        this.appendHashCode(message);
        this.appendToString(message);
        this.appendAsString(message);
        this.appendCompareTo(message);
    }

    private void appendCompact(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public boolean compact() {").begin();
        if (message.descriptor().isCompactible()) {
            this.writer.appendln("boolean missing = false;");
            boolean hasCheck = false;
            for (JField field : message.fields()) {
                if (!field.alwaysPresent()) {
                    hasCheck = true;
                    this.writer.formatln("if (%s()) {", field.presence()).appendln("    if (missing) return false;").appendln("} else {").appendln("    missing = true;").appendln('}');
                    continue;
                }
                if (!hasCheck) continue;
                this.writer.appendln("if (missing) return false;");
                hasCheck = false;
            }
            this.writer.appendln("return true;");
        } else {
            this.writer.appendln("return false;");
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendGetter(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public Object get(int key) {").begin().appendln("switch(key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: return %s();", field.id(), field.getter());
        }
        this.writer.appendln("default: return null;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendPresence(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public boolean has(int key) {").begin().appendln("switch(key) {").begin();
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("case %d: return %s() > 0;", field.id(), field.counter());
                continue;
            }
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return true;", field.id());
                continue;
            }
            this.writer.formatln("case %d: return %s();", field.id(), field.presence());
        }
        this.writer.appendln("default: return false;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendCounter(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public int num(int key) {").begin().appendln("switch(key) {").begin();
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("case %d: return %s();", field.id(), field.counter());
                continue;
            }
            if (field.alwaysPresent() && !message.isUnion()) {
                this.writer.formatln("case %d: return 1;", field.id());
                continue;
            }
            this.writer.formatln("case %d: return %s() ? 1 : 0;", field.id(), field.presence());
        }
        this.writer.appendln("default: return 0;").end().appendln('}').end().appendln('}').newline();
    }

    private void appendEquals(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public boolean equals(Object o) {").begin().appendln("if (o == this) return true;").formatln("if (o == null || !(o instanceof %s)) return false;", message.instanceType());
        if (message.fields().size() > 0) {
            boolean first = true;
            this.writer.formatln("%s other = (%s) o;", message.instanceType(), message.instanceType()).appendln("return ");
            if (message.isUnion()) {
                this.writer.format("%s.equals(tUnionField, other.tUnionField)", Objects.class.getName());
                first = false;
            }
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.append(" &&").appendln("       ");
                }
                if (field.container()) {
                    this.writer.format("%s.equals(%s, other.%s)", Objects.class.getName(), field.member(), field.member());
                    continue;
                }
                this.writer.format("%s.equals(%s, other.%s)", Objects.class.getName(), field.member(), field.member());
            }
            this.writer.append(';');
        } else {
            this.writer.appendln("return true;");
        }
        this.writer.end().appendln("}").newline();
    }

    private void appendHashCode(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public int hashCode() {").begin().appendln("if (tHashCode == 0) {").begin().formatln("tHashCode = %s.hash(", Objects.class.getName()).begin("        ").formatln("%s.class", message.instanceType());
        for (JField field : message.fields()) {
            this.writer.append(",");
            this.writer.formatln("_Field.%s, %s", field.fieldEnum(), field.member());
        }
        this.writer.end().append(");").end().appendln('}').appendln("return tHashCode;").end().appendln("}").newline();
    }

    private void appendToString(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public String toString() {").begin().formatln("return \"%s\" + asString();", message.descriptor().getQualifiedName(null)).end().appendln('}').newline();
    }

    private void appendAsString(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public String asString() {").begin().appendln("StringBuilder out = new StringBuilder();").appendln("out.append(\"{\");").newline();
        if (message.isUnion()) {
            this.writer.appendln("switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s: {", field.fieldEnum()).begin().formatln("out.append(\"%s:\")", field.name());
                switch (field.type()) {
                    case BOOL: 
                    case I32: 
                    case I64: {
                        this.writer.formatln("   .append(%s);", field.member());
                        break;
                    }
                    case BYTE: 
                    case I16: {
                        this.writer.formatln("   .append((int) %s);", field.member());
                        break;
                    }
                    case DOUBLE: 
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("   .append(%s.asString(%s));", Strings.class.getName(), field.member());
                        break;
                    }
                    case STRING: {
                        this.writer.formatln("   .append('\\\"').append(%s.escape(%s)).append('\\\"');", Strings.class.getName(), field.member());
                        break;
                    }
                    case BINARY: {
                        this.writer.formatln("   .append(\"b64(\").append(%s.toBase64()).append(')');", field.member());
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("   .append(%s.asString());", field.member());
                        break;
                    }
                    default: {
                        this.writer.formatln("   .append(%s.getName());", field.member());
                    }
                }
                this.writer.appendln("break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            boolean firstFirstCheck = true;
            boolean alwaysAfter = false;
            JField[] fields = message.fields().toArray(new JField[message.fields().size()]);
            for (int i = 0; i < fields.length; ++i) {
                boolean first = i == 0;
                boolean last = i == fields.length - 1;
                JField field = fields[i];
                if (!field.alwaysPresent()) {
                    if (!alwaysAfter && firstFirstCheck && !last) {
                        this.writer.appendln("boolean first = true;");
                    }
                    if (field.container()) {
                        this.writer.formatln("if (%s != null && %s.size() > 0) {", field.member(), field.member());
                    } else {
                        this.writer.formatln("if (%s != null) {", field.member());
                    }
                    this.writer.begin();
                }
                if (alwaysAfter) {
                    this.writer.appendln("out.append(',');");
                } else if (!field.alwaysPresent()) {
                    if (firstFirstCheck || first) {
                        if (!last) {
                            this.writer.appendln("first = false;");
                        }
                    } else if (last) {
                        this.writer.appendln("if (!first) out.append(',');");
                    } else {
                        this.writer.appendln("if (first) first = false;").appendln("else out.append(',');");
                    }
                }
                this.writer.formatln("out.append(\"%s:\")", field.name());
                switch (field.type()) {
                    case BOOL: 
                    case I32: 
                    case I64: {
                        this.writer.formatln("   .append(%s);", field.member());
                        break;
                    }
                    case BYTE: 
                    case I16: {
                        this.writer.formatln("   .append((int) %s);", field.member());
                        break;
                    }
                    case DOUBLE: 
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("   .append(%s.asString(%s));", Strings.class.getName(), field.member());
                        break;
                    }
                    case STRING: {
                        this.writer.appendln("   .append('\\\"')").formatln("   .append(%s.escape(%s))", Strings.class.getName(), field.member()).appendln("   .append('\\\"');");
                        break;
                    }
                    case BINARY: {
                        this.writer.appendln("   .append(\"b64(\")").formatln("   .append(%s.toBase64())", field.member()).appendln("   .append(')');");
                        break;
                    }
                    case MESSAGE: {
                        this.writer.formatln("   .append(%s.asString());", field.member());
                        break;
                    }
                    default: {
                        this.writer.formatln("   .append(%s.toString());", field.member());
                    }
                }
                if (!field.alwaysPresent()) {
                    this.writer.end().appendln('}');
                    if (alwaysAfter || !firstFirstCheck) continue;
                    firstFirstCheck = false;
                    continue;
                }
                alwaysAfter = true;
            }
        }
        this.writer.appendln("out.append('}');").appendln("return out.toString();").end().appendln("}").newline();
    }

    private void appendCompareTo(JMessage<?> message) {
        this.writer.appendln("@Override").formatln("public int compareTo(%s other) {", message.instanceType()).begin();
        if (message.isUnion()) {
            this.writer.appendln("int c = Integer.compare(tUnionField.getKey(), other.tUnionField.getKey());").appendln("if (c != 0) return c;").newline().appendln("switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s:", field.fieldEnum()).begin();
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("return Boolean.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("return Byte.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I16: {
                        this.writer.formatln("return Short.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I32: {
                        this.writer.formatln("return Integer.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I64: {
                        this.writer.formatln("return Long.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("return Double.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("return %s.compareTo(other.%s);", field.member(), field.member());
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("return Integer.compare(%s.getValue(), other.%s.getValue());", field.member(), field.member());
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("return Integer.compare(%s.hashCode(), other.%s.hashCode());", field.member(), field.member());
                    }
                }
                this.writer.end();
            }
            this.writer.appendln("default: return 0;").end().appendln('}');
        } else {
            this.writer.appendln("int c;");
            for (JField field : message.fields()) {
                this.writer.newline();
                if (!field.alwaysPresent()) {
                    this.writer.formatln("c = Boolean.compare(%s != null, other.%s != null);", field.member(), field.member()).appendln("if (c != 0) return c;").formatln("if (%s != null) {", field.member()).begin();
                }
                switch (field.type()) {
                    case BOOL: {
                        this.writer.formatln("c = Boolean.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case BYTE: {
                        this.writer.formatln("c = Byte.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I16: {
                        this.writer.formatln("c = Short.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I32: {
                        this.writer.formatln("c = Integer.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case I64: {
                        this.writer.formatln("c = Long.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case DOUBLE: {
                        this.writer.formatln("c = Double.compare(%s, other.%s);", field.member(), field.member());
                        break;
                    }
                    case STRING: 
                    case BINARY: 
                    case MESSAGE: {
                        this.writer.formatln("c = %s.compareTo(other.%s);", field.member(), field.member());
                        break;
                    }
                    case ENUM: {
                        this.writer.formatln("c = Integer.compare(%s.getValue(), %s.getValue());", field.member(), field.member());
                        break;
                    }
                    case SET: 
                    case LIST: 
                    case MAP: {
                        this.writer.formatln("c = Integer.compare(%s.hashCode(), other.%s.hashCode());", field.member(), field.member());
                    }
                }
                this.writer.appendln("if (c != 0) return c;");
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
            this.writer.newline().appendln("return 0;");
        }
        this.writer.end().appendln("}").newline();
    }
}

