/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.generator.format.java;

import java.util.BitSet;
import java.util.Collection;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.utils.BlockCommentBuilder;
import net.morimekta.providence.generator.format.java.utils.JAnnotation;
import net.morimekta.providence.generator.format.java.utils.JField;
import net.morimekta.providence.generator.format.java.utils.JHelper;
import net.morimekta.providence.generator.format.java.utils.JMessage;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class JMessageBuilderFormat {
    private final JOptions options;
    private final IndentedPrintWriter writer;
    private final JHelper helper;

    public JMessageBuilderFormat(IndentedPrintWriter writer, JHelper helper, JOptions options) {
        this.writer = writer;
        this.helper = helper;
        this.options = options;
    }

    public void appendBuilder(JMessage<?> message) throws GeneratorException {
        this.appendMutators(message);
        if (JAnnotation.isDeprecated(message.descriptor())) {
            this.writer.appendln("@Deprecated");
        }
        this.writer.appendln("public static class _Builder").begin().formatln("    extends %s<%s,_Field> {", PMessageBuilder.class.getName(), message.instanceType());
        this.appendFields(message);
        this.appendDefaultConstructor(message);
        this.appendMutateConstructor(message);
        this.appendMerge(message);
        for (JField field : message.fields()) {
            this.appendSetter(message, field);
            if (field.container()) {
                this.appendAdder(message, field);
            }
            this.appendIsSet(message, field);
            this.appendResetter(message, field);
            this.appendMutableGetters(message, field);
        }
        this.appendOverrideMutator(message);
        this.appendOverrideSetter(message);
        this.appendOverrideAdder(message);
        this.appendOverrideResetter(message);
        this.appendOverrideIsValid(message);
        this.appendOverrideDescriptor(message);
        this.writer.appendln("@Override").formatln("public %s build() {", message.instanceType()).begin().formatln("return new %s(this);", message.instanceType()).end().appendln('}');
        this.writer.end().appendln('}');
    }

    private void appendMutators(JMessage message) {
        this.writer.appendln("@Override").appendln("public _Builder mutate() {").begin().appendln("return new _Builder(this);").end().appendln('}').newline();
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").return_("The builder instance.").finish();
        this.writer.formatln("public static _Builder builder() {", new Object[0]).begin().appendln("return new _Builder();").end().appendln('}').newline();
    }

    private void appendFields(JMessage<?> message) throws GeneratorException {
        if (message.isUnion()) {
            this.writer.appendln("private _Field tUnionField;");
        } else {
            this.writer.formatln("private %s optionals;", BitSet.class.getName());
        }
        this.writer.newline();
        for (JField field : message.fields()) {
            this.writer.formatln("private %s %s;", field.builderFieldType(), field.member());
            if (field.type() != PType.MESSAGE) continue;
            this.writer.formatln("private %s._Builder %s_builder;", field.builderFieldType(), field.member());
        }
        if (message.fields().size() > 0) {
            this.writer.newline();
        }
    }

    private void appendDefaultConstructor(JMessage<?> message) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a " + message.descriptor().getQualifiedName(null) + " builder.").finish();
        this.writer.appendln("public _Builder() {").begin();
        if (!message.isUnion()) {
            this.writer.formatln("optionals = new %s(%d);", BitSet.class.getName(), message.fields().size());
        }
        for (JField field : message.fields()) {
            if (field.container()) {
                this.writer.formatln("%s = new %s<>();", field.member(), field.builderInstanceType());
                continue;
            }
            if (!field.alwaysPresent()) continue;
            this.writer.formatln("%s = %s;", field.member(), field.kDefault());
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMutateConstructor(JMessage<?> message) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Make a mutating builder off a base " + message.descriptor().getQualifiedName(null) + ".").newline().param_("base", "The base " + message.descriptor().getName()).finish();
        this.writer.formatln("public _Builder(%s base) {", message.instanceType()).begin().appendln("this();").newline();
        if (message.isUnion()) {
            this.writer.appendln("tUnionField = base.tUnionField;").newline();
        }
        for (JField field : message.fields()) {
            boolean checkPresence;
            boolean bl = message.isUnion() ? field.container() : (checkPresence = !field.alwaysPresent());
            if (checkPresence) {
                if (field.container()) {
                    this.writer.formatln("if (base.%s() > 0) {", field.counter()).begin();
                } else {
                    this.writer.formatln("if (base.%s()) {", field.presence()).begin();
                }
            }
            if (!message.isUnion()) {
                this.writer.formatln("optionals.set(%d);", field.index());
            }
            switch (field.type()) {
                case LIST: 
                case SET: {
                    this.writer.formatln("%s.addAll(base.%s);", field.member(), field.member());
                    break;
                }
                case MAP: {
                    this.writer.formatln("%s.putAll(base.%s);", field.member(), field.member());
                    break;
                }
                default: {
                    this.writer.formatln("%s = base.%s;", field.member(), field.member());
                }
            }
            if (!checkPresence) continue;
            this.writer.end().appendln('}');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendMerge(JMessage<?> message) throws GeneratorException {
        this.writer.appendln("@Override").formatln("public _Builder merge(%s from) {", message.instanceType()).begin();
        if (message.isUnion()) {
            this.writer.appendln("if (from.unionField() == null) {").appendln("    return this;").appendln("}").newline().appendln("switch (from.unionField()) {").begin();
            for (JField field : message.fields()) {
                this.writer.formatln("case %s: {", field.fieldEnum()).begin();
                switch (field.type()) {
                    case MESSAGE: {
                        this.writer.formatln("if (tUnionField == _Field.%s && %s != null) {", field.fieldEnum(), field.member()).formatln("    %s = %s.mutate().merge(from.%s()).build();", field.member(), field.member(), field.getter()).appendln("} else {").formatln("    %s(from.%s());", field.setter(), field.getter()).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("if (tUnionField == _Field.%s) {", field.fieldEnum()).formatln("    %s.addAll(from.%s()):", field.member(), field.getter()).appendln("} else {").formatln("    %s(from.%s());", field.setter(), field.getter()).appendln('}');
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("if (tUnionField == _Field.%s) {", field.fieldEnum()).formatln("    %s.putAll(from.%s()):", field.member(), field.getter()).appendln("} else {").formatln("    %s(from.%s());", field.setter(), field.getter()).appendln('}');
                        break;
                    }
                    default: {
                        this.writer.formatln("%s(from.%s());", field.setter(), field.getter());
                    }
                }
                this.writer.appendln("break;").end().appendln('}');
            }
            this.writer.end().appendln('}');
        } else {
            boolean first = true;
            for (JField field : message.fields()) {
                if (first) {
                    first = false;
                } else {
                    this.writer.newline();
                }
                if (!field.alwaysPresent()) {
                    this.writer.formatln("if (from.%s()) {", field.presence()).begin();
                }
                this.writer.formatln("optionals.set(%d);", field.index());
                switch (field.type()) {
                    case MESSAGE: {
                        this.writer.formatln("if (%s_builder != null) {", field.member()).formatln("    %s_builder.merge(from.%s());", field.member(), field.getter()).formatln("} else if (%s != null) {", field.member()).formatln("    %s_builder = %s.mutate().merge(from.%s());", field.member(), field.member(), field.getter()).formatln("    %s = null;", field.member()).appendln("} else {").formatln("    %s = from.%s();", field.member(), field.getter()).appendln('}');
                        break;
                    }
                    case SET: {
                        this.writer.formatln("%s.addAll(from.%s());", field.member(), field.getter());
                        break;
                    }
                    case MAP: {
                        this.writer.formatln("%s.putAll(from.%s());", field.member(), field.getter());
                        break;
                    }
                    case LIST: {
                        this.writer.formatln("%s.clear();", field.member());
                        this.writer.formatln("%s.addAll(from.%s());", field.member(), field.getter());
                        break;
                    }
                    default: {
                        this.writer.formatln("%s = from.%s();", field.member(), field.getter());
                    }
                }
                if (field.alwaysPresent()) continue;
                this.writer.end().appendln('}');
            }
        }
        this.writer.appendln("return this;").end().appendln('}').newline();
    }

    private void appendSetter(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Sets the value of " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.param_("value", "The new value").return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln("@Deprecated");
        }
        if (field.type() == PType.SET || field.type() == PType.LIST) {
            PContainer cType = (PContainer)field.getPField().getDescriptor();
            String iType = this.helper.getFieldType(cType.itemDescriptor());
            this.writer.formatln("public _Builder %s(%s<%s> value) {", field.setter(), Collection.class.getName(), iType);
        } else {
            this.writer.formatln("public _Builder %s(%s value) {", field.setter(), field.valueType());
        }
        this.writer.begin();
        if (message.isUnion()) {
            this.writer.formatln("tUnionField = _Field.%s;", field.fieldEnum());
        } else {
            this.writer.formatln("optionals.set(%d);", field.index());
        }
        switch (field.type()) {
            case LIST: 
            case SET: {
                this.writer.formatln("%s.clear();", field.member()).formatln("%s.addAll(value);", field.member());
                break;
            }
            case MAP: {
                this.writer.formatln("%s.clear();", field.member()).formatln("%s.putAll(value);", field.member());
                break;
            }
            case MESSAGE: {
                this.writer.formatln("%s_builder = null;", field.member());
            }
            default: {
                this.writer.formatln("%s = value;", field.member());
            }
        }
        this.writer.appendln("return this;").end().appendln('}').newline();
    }

    private void appendAdder(JMessage message, JField field) throws GeneratorException {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        if (field.type() == PType.MAP) {
            comment.comment("Adds a mapping to " + field.name() + ".").newline();
        } else {
            comment.comment("Adds entries to " + field.name() + ".").newline();
        }
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        if (field.type() == PType.MAP) {
            comment.param_("key", "The inserted key").param_("value", "The inserted value");
        } else {
            comment.param_("values", "The added value");
        }
        comment.return_("The builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln("@Deprecated");
        }
        switch (field.type()) {
            case MAP: {
                PMap mType = (PMap)field.getPField().getDescriptor();
                String mkType = this.helper.getValueType(mType.keyDescriptor());
                String miType = this.helper.getValueType(mType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s key, %s value) {", field.adder(), mkType, miType).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", field.fieldEnum());
                } else {
                    this.writer.formatln("optionals.set(%d);", field.index());
                }
                this.writer.formatln("%s.put(key, value);", field.member()).appendln("return this;").end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: {
                PContainer lType = (PContainer)field.getPField().getDescriptor();
                String liType = this.helper.getValueType(lType.itemDescriptor());
                this.writer.formatln("public _Builder %s(%s... values) {", field.adder(), liType).begin();
                if (message.isUnion()) {
                    this.writer.formatln("tUnionField = _Field.%s;", field.fieldEnum());
                } else {
                    this.writer.formatln("optionals.set(%d);", field.index());
                }
                this.writer.formatln("for (%s item : values) {", liType).begin().formatln("%s.add(item);", field.member()).end().appendln('}').appendln("return this;").end().appendln('}').newline();
                break;
            }
        }
    }

    private void appendIsSet(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Checks for presence of the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_(String.format("True iff %s has been set.", field.name())).finish();
        this.writer.formatln("public boolean %s() {", field.isSet()).begin();
        if (message.isUnion()) {
            this.writer.formatln("return tUnionField == _Field.%s;", field.fieldEnum());
        } else {
            this.writer.formatln("return optionals.get(%d);", field.index());
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendResetter(JMessage message, JField field) {
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Clears the " + field.name() + " field.").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The builder").finish();
        this.writer.formatln("public _Builder %s() {", field.resetter()).begin();
        if (message.isUnion()) {
            this.writer.formatln("if (tUnionField == _Field.%s) tUnionField = null;", field.fieldEnum());
        } else {
            this.writer.formatln("optionals.clear(%d);", field.index());
        }
        if (field.container()) {
            this.writer.formatln("%s.clear();", field.member());
        } else if (field.alwaysPresent()) {
            this.writer.formatln("%s = %s;", field.member(), field.kDefault());
        } else {
            this.writer.formatln("%s = null;", field.member());
            if (field.type() == PType.MESSAGE) {
                this.writer.formatln("%s_builder = null;", field.member());
            }
        }
        this.writer.appendln("return this;").end().appendln('}').newline();
    }

    private void appendMutableGetters(JMessage message, JField field) throws GeneratorException {
        if (field.getPField().getDescriptor() instanceof PPrimitive || field.type() == PType.ENUM) {
            return;
        }
        BlockCommentBuilder comment = new BlockCommentBuilder(this.writer);
        comment.comment("Gets the builder for the contained " + field.name() + ".").newline();
        if (field.hasComment()) {
            comment.comment(field.comment()).newline();
        }
        comment.return_("The field builder").finish();
        if (JAnnotation.isDeprecated(field)) {
            this.writer.appendln("@Deprecated");
        }
        switch (field.type()) {
            case MESSAGE: {
                this.writer.formatln("public %s._Builder %s() {", field.instanceType(), Strings.camelCase("mutable", field.name())).begin();
                if (message.isUnion()) {
                    this.writer.formatln("if (tUnionField != _Field.%s) {", field.fieldEnum()).formatln("    %s();", field.resetter()).appendln('}').formatln("tUnionField = _Field.%s;", field.fieldEnum());
                } else {
                    this.writer.formatln("optionals.set(%d);", field.index());
                }
                this.writer.newline().formatln("if (%s != null) {", field.member()).formatln("    %s_builder = %s.mutate();", field.member(), field.member()).formatln("    %s = null;", field.member()).formatln("} else if (%s_builder == null) {", field.member()).formatln("    %s_builder = %s.builder();", field.member(), field.instanceType()).appendln('}').formatln("return %s_builder;", field.member());
                this.writer.end().appendln('}').newline();
                break;
            }
            case LIST: 
            case SET: 
            case MAP: {
                this.writer.formatln("public %s %s() {", field.builderFieldType(), Strings.camelCase("mutable", field.name())).begin();
                this.writer.formatln("return %s;", field.member());
                this.writer.end().appendln('}').newline();
                break;
            }
            default: {
                throw new GeneratorException("Unexpected field type: " + (Object)((Object)field.type()));
            }
        }
    }

    private void appendOverrideMutator(JMessage<?> message) throws GeneratorException {
        this.writer.appendln("@Override").appendln("@SuppressWarnings(\"unchecked\")").formatln("public %s mutator(int key) {", PMessageBuilder.class.getName()).begin().appendln("switch (key) {").begin();
        message.fields().stream().filter(field -> field.type() == PType.MESSAGE).forEachOrdered(field -> this.writer.formatln("case %d: return %s();", field.id(), Strings.camelCase("mutable", field.name())));
        this.writer.appendln("default: throw new IllegalArgumentException(\"Not a message field ID: \" + key);").end().appendln('}').end().appendln('}').newline();
    }

    private void appendOverrideSetter(JMessage<?> message) throws GeneratorException {
        this.writer.appendln("@Override").appendln("@SuppressWarnings(\"unchecked\")").appendln("public _Builder set(int key, Object value) {").begin().appendln("if (value == null) return clear(key);").appendln("switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s((%s) value); break;", field.id(), field.setter(), field.valueType());
        }
        this.writer.end().appendln('}').appendln("return this;").end().appendln('}').newline();
    }

    private void appendOverrideAdder(JMessage<?> message) throws GeneratorException {
        this.writer.appendln("@Override").appendln("public _Builder addTo(int key, Object value) {").begin().appendln("switch (key) {").begin();
        for (JField field : message.fields()) {
            if (field.type() != PType.LIST && field.type() != PType.SET) continue;
            PContainer ct = (PContainer)field.getPField().getDescriptor();
            PDescriptor itype = ct.itemDescriptor();
            this.writer.formatln("case %d: %s((%s) value); break;", field.id(), field.adder(), this.helper.getValueType(itype));
        }
        this.writer.appendln("default: break;").end().appendln('}').appendln("return this;").end().appendln('}').newline();
    }

    private void appendOverrideResetter(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public _Builder clear(int key) {").begin().appendln("switch (key) {").begin();
        for (JField field : message.fields()) {
            this.writer.formatln("case %d: %s(); break;", field.id(), field.resetter());
        }
        this.writer.end().appendln('}').appendln("return this;").end().appendln('}').newline();
    }

    private void appendOverrideIsValid(JMessage<?> message) {
        this.writer.appendln("@Override").appendln("public boolean isValid() {").begin();
        if (message.isUnion()) {
            this.writer.appendln("if (tUnionField == null) {").appendln("    return false;").appendln('}').newline().appendln("switch (tUnionField) {").begin();
            for (JField field : message.fields()) {
                if (field.alwaysPresent()) continue;
                if (field.type() == PType.MESSAGE) {
                    this.writer.formatln("case %s: return %s != null || %s_builder != null;", field.fieldEnum(), field.member(), field.member());
                    continue;
                }
                this.writer.formatln("case %s: return %s != null;", field.fieldEnum(), field.member());
            }
            this.writer.appendln("default: return true;").end().appendln('}');
        } else {
            this.writer.appendln("return ").begin("       ");
            boolean first = true;
            for (JField field : message.fields()) {
                if (!field.isRequired()) continue;
                if (first) {
                    first = false;
                } else {
                    this.writer.append(" &&").appendln("");
                }
                this.writer.format("optionals.get(%d)", field.index());
            }
            if (first) {
                this.writer.append("true");
            }
            this.writer.end().append(';');
        }
        this.writer.end().appendln('}').newline();
    }

    private void appendOverrideDescriptor(JMessage<?> message) throws GeneratorException {
        String typeClass = message.getDescriptorClass();
        this.writer.appendln("@Override").formatln("public %s<%s,_Field> descriptor() {", typeClass, message.instanceType()).begin().appendln("return kDescriptor;").end().appendln('}').newline();
    }
}

