/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PServiceProvider;

public class PService {
    private final String name;
    private final String packageName;
    private final PServiceProvider extendsService;
    private final Collection<? extends PServiceMethod> methods;

    public PService(String packageName, String name, PServiceProvider extendsService, Collection<? extends PServiceMethod> methods) {
        this.name = name;
        this.packageName = packageName;
        this.extendsService = extendsService;
        this.methods = methods;
    }

    public PService(String packageName, String name, PServiceProvider extendsService, PServiceMethod[] methods) {
        this.name = name;
        this.packageName = packageName;
        this.extendsService = extendsService;
        this.methods = ImmutableList.copyOf(methods);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public PService getExtendsService() {
        if (this.extendsService != null) {
            return this.extendsService.getService();
        }
        return null;
    }

    public Collection<? extends PServiceMethod> getMethods() {
        return this.methods;
    }

    public PServiceMethod getMethod(String name) {
        for (PServiceMethod pServiceMethod : this.methods) {
            if (!pServiceMethod.getName().equals(name)) continue;
            return pServiceMethod;
        }
        if (this.extendsService != null) {
            return this.extendsService.getService().getMethod(name);
        }
        return null;
    }

    public String getQualifiedName(String packageContext) {
        if (this.packageName.equals(packageContext)) {
            return this.name;
        }
        return this.packageName + "." + this.name;
    }
}

