/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.compiler.options;

import java.util.function.Consumer;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseOption;
import net.morimekta.providence.compiler.options.HelpSpec;
import net.morimekta.providence.generator.Language;

public class HelpOption
extends BaseOption {
    private final Consumer<HelpSpec> consumer;

    public HelpOption(String name, String shortNames, String usage, Consumer<HelpSpec> consumer) {
        super(name, shortNames, "[language]", usage, null, false, false, false);
        this.consumer = consumer;
    }

    @Override
    public void validate() {
    }

    @Override
    public int applyShort(String opts, ArgumentList args) {
        if (opts.length() > 1) {
            throw new ArgumentException("Only one help param: " + args.get(0), new Object[0]);
        }
        this.consumer.accept(new HelpSpec(this.getLanguage(args)));
        return args.remaining();
    }

    @Override
    public int apply(ArgumentList args) {
        this.consumer.accept(new HelpSpec(this.getLanguage(args)));
        return args.remaining();
    }

    private Language getLanguage(ArgumentList args) {
        if (args.remaining() > 2) {
            throw new ArgumentException("Only one help spec allowed", new Object[0]);
        }
        Language language = null;
        if (args.remaining() > 1) {
            String lang = args.get(1);
            for (Language spec : Language.values()) {
                if (!lang.equalsIgnoreCase(spec.name())) continue;
                language = spec;
                break;
            }
            if (language == null) {
                throw new ArgumentException("Unknown language " + lang, new Object[0]);
            }
        }
        return language;
    }
}

