/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.compiler.options;

import java.util.Collections;
import java.util.LinkedList;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.util.Parser;
import net.morimekta.providence.compiler.options.GeneratorSpec;
import net.morimekta.providence.generator.Language;

public class GeneratorSpecParser
implements Parser<GeneratorSpec> {
    @Override
    public GeneratorSpec parse(String spec) {
        Language generator = null;
        LinkedList<String> options = new LinkedList<String>();
        String[] gen = spec.split("[:]", 2);
        if (gen.length > 2) {
            throw new ArgumentException("Invalid generator spec, only one ':' allowed: " + spec, new Object[0]);
        }
        for (Language lang : Language.values()) {
            if (!gen[0].equalsIgnoreCase(lang.name())) continue;
            generator = lang;
            break;
        }
        if (generator == null) {
            throw new ArgumentException("Unknown output language " + gen[0], new Object[0]);
        }
        if (gen.length == 2) {
            Collections.addAll(options, gen[1].split("[,]"));
        }
        return new GeneratorSpec(generator, options);
    }
}

