/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.compiler;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.morimekta.console.args.Argument;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentOptions;
import net.morimekta.console.args.ArgumentParser;
import net.morimekta.console.args.Option;
import net.morimekta.console.util.Parser;
import net.morimekta.console.util.TerminalSize;
import net.morimekta.providence.compiler.options.GeneratorSpec;
import net.morimekta.providence.compiler.options.GeneratorSpecParser;
import net.morimekta.providence.compiler.options.HelpOption;
import net.morimekta.providence.compiler.options.HelpSpec;
import net.morimekta.providence.compiler.options.Syntax;
import net.morimekta.providence.generator.Generator;
import net.morimekta.providence.generator.GeneratorException;
import net.morimekta.providence.generator.format.java.JGenerator;
import net.morimekta.providence.generator.format.java.JOptions;
import net.morimekta.providence.generator.format.java.tiny.TinyGenerator;
import net.morimekta.providence.generator.format.java.tiny.TinyOptions;
import net.morimekta.providence.generator.format.json.JsonGenerator;
import net.morimekta.providence.generator.util.FileManager;
import net.morimekta.providence.reflect.TypeLoader;
import net.morimekta.providence.reflect.parser.DocumentParser;
import net.morimekta.providence.reflect.parser.MessageDocumentParser;
import net.morimekta.providence.reflect.parser.ThriftDocumentParser;
import net.morimekta.providence.serializer.JsonSerializer;

public class CompilerOptions {
    protected File out = new File(".");
    protected List<File> includes = new LinkedList<File>();
    protected Syntax syntax = Syntax.thrift;
    protected HelpSpec help = null;
    protected GeneratorSpec gen = null;
    protected List<File> files = new LinkedList<File>();

    public ArgumentParser getArgumentParser(String prog, String version, String description) {
        ArgumentOptions opts = ArgumentOptions.defaults().withUsageWidth(Math.min(120, TerminalSize.get().cols));
        ArgumentParser parser = new ArgumentParser(prog, version, description, opts);
        parser.add(new Option("--gen", "g", "generator", "Generate files for this language spec.", new GeneratorSpecParser().andApply(this::setGenerator)));
        parser.add(new HelpOption("--help", "h?", "Show this help or about language.", this::setHelp));
        parser.add(new Option("--include", "I", "dir", "Allow includes of files in directory", Parser.dir(this::addInclude), null, true, false, false));
        parser.add(new Option("--out", "o", "dir", "Output directory", Parser.dir(this::setOut), "${PWD}"));
        parser.add(new Option("--syntax", null, "syntax", "Input file syntax", Parser.oneOf(Syntax.class, this::setSyntax), "thrift", false, false, true));
        parser.add(new Argument("file", "Files to compile.", Parser.file(this::addFile), null, null, true, true, false));
        return parser;
    }

    public void setOut(File out) {
        this.out = out;
    }

    public void addInclude(File includes) {
        this.includes.add(includes);
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public void setHelp(HelpSpec help) {
        this.help = help;
    }

    public void setGenerator(GeneratorSpec gen) {
        this.gen = gen;
    }

    public void addFile(File files) {
        this.files.add(files);
    }

    public boolean isHelp() {
        return this.help != null;
    }

    public List<File> getIncludes() throws ArgumentException {
        return this.includes;
    }

    public List<File> getInputFiles() throws ArgumentException {
        return this.files;
    }

    public FileManager getFileManager() throws ArgumentException {
        if (!this.out.exists() && !this.out.mkdirs()) {
            throw new ArgumentException("Unable to create directory %s", this.out.toString());
        }
        return new FileManager(this.out);
    }

    public DocumentParser getParser() throws ArgumentException {
        switch (this.syntax) {
            case thrift: {
                return new ThriftDocumentParser();
            }
            case json: {
                return new MessageDocumentParser(new JsonSerializer());
            }
        }
        throw new ArgumentException("Unknown SLI syntax %s.", this.syntax.name());
    }

    public Generator getGenerator(TypeLoader loader) throws ArgumentException, GeneratorException {
        switch (this.gen.generator) {
            case json: {
                return new JsonGenerator(this.getFileManager(), loader);
            }
            case java: {
                JOptions options = new JOptions();
                Iterator<String> iterator = this.gen.options.iterator();
                block17: while (iterator.hasNext()) {
                    String opt;
                    switch (opt = iterator.next()) {
                        case "android": {
                            options.android = true;
                            continue block17;
                        }
                    }
                    throw new ArgumentException("No such option for java generator: " + opt, new Object[0]);
                }
                return new JGenerator(this.getFileManager(), loader.getRegistry(), options);
            }
            case tiny_java: {
                TinyOptions options = new TinyOptions();
                Iterator<String> iterator = this.gen.options.iterator();
                block18: while (iterator.hasNext()) {
                    String opt;
                    switch (opt = iterator.next()) {
                        case "jackson": {
                            options.jackson = true;
                            continue block18;
                        }
                    }
                    throw new ArgumentException("No such option for tiny_java generator: " + opt, new Object[0]);
                }
                return new TinyGenerator(this.getFileManager(), loader.getRegistry(), options);
            }
        }
        throw new ArgumentException("Unknown language %s.", this.gen.generator.name());
    }
}

