/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;

public class TerminalSize {
    public final int rows;
    public final int cols;

    @VisibleForTesting
    public TerminalSize(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    public String toString() {
        return String.format("tty(rows:%d, cols:%d)", this.rows, this.cols);
    }

    public static TerminalSize get() {
        try {
            return TerminalSize.get(Runtime.getRuntime());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static TerminalSize get(Runtime runtime) throws IOException {
        String[] cmd = new String[]{"/bin/sh", "-c", "stty size </dev/tty"};
        Process p = runtime.exec(cmd);
        try {
            p.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getMessage(), ie);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
            String err = reader.readLine();
            if (err != null) {
                throw new IOException(err);
            }
        }
        reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        var4_5 = null;
        try {
            String out = reader.readLine();
            if (out == null) throw new IOException("No 'stty size' output.");
            String[] parts = out.trim().split("[ ]");
            if (parts.length == 2) {
                int rows = Integer.parseInt(parts[0]);
                int cols = Integer.parseInt(parts[1]);
                TerminalSize terminalSize = new TerminalSize(rows, cols);
                return terminalSize;
            }
            try {
                throw new IOException("Unknown 'stty size' output: " + out);
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        finally {
            if (reader != null) {
                if (var4_5 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }
}

