/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.Property;

@FunctionalInterface
public interface Parser<T> {
    public T parse(String var1);

    default public Consumer<String> andApply(Consumer<T> consumer) {
        return s -> consumer.accept(this.parse((String)s));
    }

    default public Property.Putter andPut(TypedPutter<T> putter) {
        return (k, v) -> putter.put(k, this.parse(v));
    }

    default public Consumer<String> andPutAs(TypedPutter<T> putter, String key) {
        return s -> putter.put(key, this.parse((String)s));
    }

    public static Consumer<String> putAs(Property.Putter putter, String key) {
        return s -> putter.put(key, (String)s);
    }

    public static Parser<Integer> i32() {
        return new IntegerParser();
    }

    public static Consumer<String> i32(Consumer<Integer> target) {
        return Parser.i32().andApply(target);
    }

    public static Parser<Long> i64() {
        return new LongParser();
    }

    public static Consumer<String> i64(Consumer<Long> target) {
        return Parser.i64().andApply(target);
    }

    public static Parser<Double> dbl() {
        return new DoubleParser();
    }

    public static Consumer<String> dbl(Consumer<Double> target) {
        return Parser.dbl().andApply(target);
    }

    public static <E extends Enum<E>> Parser<E> oneOf(Class<E> klass) {
        return new EnumParser<E>(klass);
    }

    public static <E extends Enum<E>> Consumer<String> oneOf(Class<E> klass, Consumer<E> target) {
        return Parser.oneOf(klass).andApply(target);
    }

    public static Parser<File> file() {
        return new FileParser();
    }

    public static Consumer<String> file(Consumer<File> target) {
        return Parser.file().andApply(target);
    }

    public static Parser<File> dir() {
        return new DirParser();
    }

    public static Consumer<String> dir(Consumer<File> target) {
        return Parser.dir().andApply(target);
    }

    public static Parser<File> outputFile() {
        return new OutputFileParser();
    }

    public static Consumer<String> outputFile(Consumer<File> target) {
        return Parser.outputFile().andApply(target);
    }

    public static Parser<File> outputDir() {
        return new OutputDirParser();
    }

    public static Consumer<String> outputDir(Consumer<File> target) {
        return Parser.outputDir().andApply(target);
    }

    public static Parser<Path> path() {
        return new PathParser();
    }

    public static Consumer<String> path(Consumer<Path> target) {
        return Parser.path().andApply(target);
    }

    public static class DoubleParser
    implements Parser<Double> {
        @Override
        public Double parse(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentException(nfe, "Invalid double value " + s, new Object[0]);
            }
        }
    }

    public static class EnumParser<E extends Enum<E>>
    implements Parser<E> {
        private final Class<E> klass;

        public EnumParser(Class<E> klass) {
            this.klass = klass;
        }

        @Override
        public E parse(String name) {
            try {
                return (E)((Enum)this.klass.getDeclaredMethod("valueOf", String.class).invoke(null, name));
            }
            catch (InvocationTargetException e) {
                throw new ArgumentException(e.getCause(), "Invalid " + this.klass.getSimpleName() + " value " + name, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public static class OutputDirParser
    implements Parser<File> {
        @Override
        public File parse(String s) {
            File result = new File(s);
            if (result.exists() && !result.isDirectory()) {
                throw new ArgumentException(s + " exists and is not a directory", new Object[0]);
            }
            return result;
        }
    }

    public static class OutputFileParser
    implements Parser<File> {
        @Override
        public File parse(String s) {
            File result = new File(s);
            if (result.exists() && !result.isFile()) {
                throw new ArgumentException(s + " exists and is not a file", new Object[0]);
            }
            return result;
        }
    }

    public static class DirParser
    implements Parser<File> {
        @Override
        public File parse(String s) {
            File result = new File(s);
            if (!result.exists()) {
                throw new ArgumentException("No such directory " + s, new Object[0]);
            }
            if (!result.isDirectory()) {
                throw new ArgumentException(s + " is not a directory", new Object[0]);
            }
            return result;
        }
    }

    public static class FileParser
    implements Parser<File> {
        @Override
        public File parse(String s) {
            File result = new File(s);
            if (!result.exists()) {
                throw new ArgumentException("No such file " + s, new Object[0]);
            }
            if (!result.isFile()) {
                throw new ArgumentException(s + " is not a file", new Object[0]);
            }
            return result;
        }
    }

    public static class IntegerParser
    implements Parser<Integer> {
        @Override
        public Integer parse(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentException(nfe, "Invalid integer value " + s, new Object[0]);
            }
        }
    }

    public static class LongParser
    implements Parser<Long> {
        @Override
        public Long parse(String s) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentException(nfe, "Invalid long value " + s, new Object[0]);
            }
        }
    }

    public static class PathParser
    implements Parser<Path> {
        @Override
        public Path parse(String s) {
            return Paths.get(s, new String[0]);
        }
    }

    @FunctionalInterface
    public static interface TypedPutter<T> {
        public void put(String var1, T var2);
    }
}

