/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.chr;

import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.console.chr.CharStream;
import net.morimekta.util.Strings;

public class CharUtil {
    public static final int TAB_WIDTH = 4;

    public static int printableWidth(String string) {
        AtomicInteger width = new AtomicInteger(0);
        CharStream.stream(string).forEach(c -> width.addAndGet(c.printableWidth()));
        return width.get();
    }

    public static String expandTabs(String string) {
        return CharUtil.expandTabs(string, 4);
    }

    public static String expandTabs(String string, int tabWidth) {
        return CharUtil.expandTabs(string, tabWidth, 0);
    }

    public static String expandTabs(String string, int tabWidth, int offset) {
        StringBuilder builder = new StringBuilder();
        AtomicInteger off = new AtomicInteger(offset);
        CharStream.stream(string).forEachOrdered(c -> {
            if (c.asInteger() == 9) {
                int l = tabWidth - off.get() % tabWidth;
                for (int i = 0; i < l; ++i) {
                    builder.append(' ');
                }
                off.addAndGet(l);
            } else {
                builder.append(c);
                off.addAndGet(c.printableWidth());
            }
        });
        return builder.toString();
    }

    public static String stripNonPrintable(String string) {
        StringBuilder builder = new StringBuilder();
        CharStream.stream(string).forEachOrdered(c -> {
            if (c.printableWidth() > 0) {
                builder.append(c.toString());
            }
        });
        return builder.toString();
    }

    public static String clipWidth(String string, int width) {
        AtomicInteger remaining = new AtomicInteger(width);
        StringBuilder builder = new StringBuilder();
        CharStream.stream(string).forEachOrdered(c -> {
            int pw = c.printableWidth();
            if (pw <= remaining.get()) {
                builder.append(c.toString());
                remaining.addAndGet(-pw);
            }
        });
        return builder.toString();
    }

    public static String leftJust(String string, int width) {
        int pw = CharUtil.printableWidth(string);
        if (pw < width) {
            return string + Strings.times(" ", width - pw);
        }
        return string;
    }

    public static String rightJust(String string, int width) {
        int pw = CharUtil.printableWidth(string);
        if (pw < width) {
            return Strings.times(" ", width - pw) + string;
        }
        return string;
    }

    private CharUtil() {
    }
}

