/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.ArgumentOptions;
import net.morimekta.console.args.ArgumentParser;
import net.morimekta.console.args.BaseArgument;
import net.morimekta.console.args.SubCommand;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;

public class SubCommandSet<SubCommandDef>
extends BaseArgument {
    private final List<SubCommand<SubCommandDef>> subCommands;
    private final Map<String, SubCommand<SubCommandDef>> subCommandMap;
    private final Consumer<SubCommandDef> consumer;
    private final ArgumentOptions argumentOptions;
    private boolean applied;
    private ArgumentParser parser;

    public SubCommandSet(String name, String usage, Consumer<SubCommandDef> consumer) {
        this(name, usage, consumer, null, true, ArgumentOptions.defaults());
    }

    public SubCommandSet(String name, String usage, Consumer<SubCommandDef> consumer, String defaultValue) {
        this(name, usage, consumer, defaultValue, false, ArgumentOptions.defaults());
    }

    public SubCommandSet(String name, String usage, Consumer<SubCommandDef> consumer, String defaultValue, boolean required, ArgumentOptions options) {
        super(name, usage, defaultValue, false, required, false);
        this.argumentOptions = options;
        this.subCommands = new LinkedList<SubCommand<SubCommandDef>>();
        this.subCommandMap = new HashMap<String, SubCommand<SubCommandDef>>();
        this.consumer = consumer;
    }

    public SubCommandSet add(SubCommand<SubCommandDef> subCommand) {
        if (this.subCommandMap.containsKey(subCommand.getName())) {
            throw new IllegalArgumentException("SubCommand with name " + subCommand.getName() + " already exists");
        }
        this.subCommands.add(subCommand);
        this.subCommandMap.put(subCommand.getName(), subCommand);
        for (String alias : subCommand.getAliases()) {
            if (this.subCommandMap.containsKey(alias)) {
                throw new IllegalArgumentException("SubCommand (" + subCommand.getName() + ") alias " + alias + " already exists");
            }
            this.subCommandMap.put(alias, subCommand);
        }
        return this;
    }

    public SubCommandSet addAll(SubCommand<SubCommandDef> ... subCommands) {
        for (SubCommand<SubCommandDef> subCommand : subCommands) {
            this.add(subCommand);
        }
        return this;
    }

    public void printUsage(OutputStream out) {
        this.printUsage(out, false);
    }

    public void printUsage(OutputStream out, boolean showHidden) {
        this.printUsage(new PrintWriter(out), showHidden);
    }

    public void printUsage(PrintWriter writer, boolean showHidden) {
        this.printUsageInternal(new IndentedPrintWriter(writer), showHidden);
    }

    public void printUsage(OutputStream out, String name) {
        this.printUsage(new PrintWriter(out), name);
    }

    public void printUsage(OutputStream out, String name, boolean showHidden) {
        this.printUsage(new PrintWriter(out), name, showHidden);
    }

    public void printUsage(PrintWriter writer, String name) {
        this.printUsage(writer, name, false);
    }

    public void printUsage(PrintWriter writer, String name, boolean showHidden) {
        for (SubCommand<SubCommandDef> cmd : this.subCommands) {
            if (!name.equals(cmd.getName())) continue;
            cmd.getArgumentParser(cmd.newInstance()).printUsage(writer, showHidden);
            return;
        }
        throw new ArgumentException("No such " + this.getName() + " " + name, new Object[0]);
    }

    @Override
    public String getSingleLineUsage() {
        List visible;
        StringBuilder sb = new StringBuilder();
        if (!this.isRequired()) {
            sb.append('[');
        }
        if ((visible = this.subCommands.stream().filter(s -> !s.isHidden()).map(SubCommand::getName).collect(Collectors.toList())).size() > 4 || visible.size() == 0) {
            sb.append(this.getName());
        } else {
            sb.append('[');
            sb.append(String.join((CharSequence)" | ", visible));
            sb.append(']');
        }
        sb.append(" [...]");
        if (!this.isRequired()) {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public String getPrefix() {
        return this.getName();
    }

    @Override
    public void validate() throws ArgumentException {
        if (this.isRequired() && !this.applied) {
            throw new ArgumentException(this.getName() + " not chosen", new Object[0]);
        }
        this.parser.validate();
    }

    @Override
    public int apply(ArgumentList args) {
        if (this.applied) {
            throw new ArgumentException(this.getName() + " already selected", new Object[0]);
        }
        String name = args.get(0);
        SubCommand<SubCommandDef> cmd = this.subCommandMap.get(name);
        if (cmd == null) {
            throw new ArgumentException("No such " + this.getName() + ": " + name, new Object[0]);
        }
        this.applied = true;
        ArgumentList subArgs = new ArgumentList(args);
        subArgs.consume(1);
        SubCommandDef instance = cmd.newInstance();
        this.parser = cmd.getArgumentParser(instance);
        this.parser.parse(subArgs);
        this.consumer.accept(instance);
        return args.remaining();
    }

    private void printUsageInternal(IndentedPrintWriter writer, boolean showHidden) {
        int usageWidth = this.argumentOptions.getUsageWidth();
        int prefixLen = 0;
        for (SubCommand<SubCommandDef> cmd : this.subCommands) {
            prefixLen = Math.max(prefixLen, cmd.getName().length());
        }
        prefixLen = Math.min(prefixLen, usageWidth / 3 - 4);
        String indent = Strings.times(" ", prefixLen + 4);
        boolean first = true;
        for (SubCommand<SubCommandDef> arg : this.subCommands) {
            if (arg.isHidden() && !showHidden) continue;
            String prefix = arg.getName();
            String usage = arg.getUsage();
            if (first) {
                first = false;
            } else {
                writer.appendln();
            }
            writer.begin(indent);
            ArgumentParser.printSingleUsageEntry(writer, prefix, usage, prefixLen, usageWidth);
            writer.end();
        }
        writer.newline().flush();
    }
}

