/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseOption;

public class Property
extends BaseOption {
    private final Putter properties;
    private final String metaKey;

    public Property(char shortName, String usage, Putter properties) {
        this(shortName, null, null, usage, properties, false);
    }

    public Property(char shortName, String metaKey, String metaVar, String usage, Putter properties) {
        this(shortName, metaKey, metaVar, usage, properties, false);
    }

    public Property(char shortName, String metaKey, String metaVar, String usage, Putter properties, boolean hidden) {
        super(null, new String(new char[]{shortName}), metaVar == null ? "val" : metaVar, usage, null, true, false, hidden);
        this.metaKey = metaKey == null ? "key" : metaKey;
        this.properties = properties;
    }

    @Override
    public String getSingleLineUsage() {
        return "[-" + this.getShortNames() + this.metaKey + '=' + this.getMetaVar() + " ...]";
    }

    @Override
    public String getPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append('-').append(this.getShortNames()).append(this.metaKey).append('=').append(this.getMetaVar());
        return sb.toString();
    }

    @Override
    public void validate() throws ArgumentException {
    }

    @Override
    public int applyShort(String opts, ArgumentList args) {
        String[] parts = opts.substring(1).split("[=]", 2);
        if (parts.length != 2) {
            throw new ArgumentException("No key value sep for properties: " + opts.substring(1), new Object[0]);
        }
        if (parts[0].length() == 0) {
            throw new ArgumentException("Empty property key: \"-" + opts + "\"", new Object[0]);
        }
        this.properties.put(parts[0], parts[1]);
        return 1;
    }

    @Override
    public int apply(ArgumentList args) {
        throw new IllegalArgumentException("Properties does not support long options");
    }

    @FunctionalInterface
    public static interface Putter {
        public void put(String var1, String var2);
    }
}

