/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.util.Comparator;
import net.morimekta.console.args.BaseOption;
import net.morimekta.console.util.TerminalSize;

public class ArgumentOptions {
    private boolean defaultsShown = true;
    private int usageWidth = 80;
    private Comparator<BaseOption> optionComparator = null;

    public static ArgumentOptions defaults() {
        return new ArgumentOptions();
    }

    public ArgumentOptions withDefaultsShown(boolean show) {
        this.defaultsShown = show;
        return this;
    }

    public boolean getDefaultsShown() {
        return this.defaultsShown;
    }

    public ArgumentOptions withUsageWidth(int usageWidth) {
        this.usageWidth = usageWidth;
        return this;
    }

    public ArgumentOptions withMaxUsageWidth(int maxWidth) {
        this.usageWidth = Math.min(maxWidth, TerminalSize.get().cols);
        return this;
    }

    public int getUsageWidth() {
        return this.usageWidth;
    }

    public ArgumentOptions withOptionComparator(Comparator<BaseOption> comparator) {
        this.optionComparator = comparator;
        return this;
    }

    public Comparator<BaseOption> getOptionComparator() {
        return this.optionComparator;
    }
}

