/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseArgument;

public class Argument
extends BaseArgument {
    private final Consumer<String> consumer;
    private final Predicate<String> predicate;
    private boolean applied;

    public Argument(String name, String usage, Consumer<String> consumer) {
        this(name, usage, consumer, null, null, false, true, false);
    }

    public Argument(String name, String usage, Consumer<String> consumer, String defaultValue) {
        this(name, usage, consumer, defaultValue, null, false, false, false);
    }

    public Argument(String name, String usage, Consumer<String> consumer, String defaultValue, Predicate<String> predicate, boolean repeated, boolean required, boolean hidden) {
        super(name, usage, defaultValue, repeated, required, hidden);
        this.consumer = consumer;
        this.predicate = predicate == null ? s -> true : predicate;
    }

    @Override
    public String getSingleLineUsage() {
        if (this.isHidden()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isRequired()) {
            sb.append("[");
        }
        sb.append(this.getName());
        if (this.isRepeated()) {
            sb.append("...");
        }
        if (!this.isRequired()) {
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String getPrefix() {
        return this.getName();
    }

    @Override
    public void validate() throws ArgumentException {
        if (this.isRequired() && !this.applied) {
            throw new ArgumentException("Argument \"" + this.getName() + "\" is required", new Object[0]);
        }
    }

    @Override
    public int apply(ArgumentList args) {
        if (this.applied && !this.isRepeated()) {
            return 0;
        }
        String cur = args.get(0);
        if (!this.predicate.test(cur)) {
            return 0;
        }
        this.applied = true;
        this.consumer.accept(cur);
        return 1;
    }
}

