package net.morher.ui.connect.http;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import net.morher.ui.connect.api.Connector;
import net.morher.ui.connect.api.exception.ApplicationConnectionFailedException;
import net.morher.ui.connect.html.HtmlElementContext;
import net.morher.ui.connect.html.HtmlRootContext;

public class Browser implements Connector<HtmlElementContext> {
    private final WebClient webClient;
    private final HtmlPage page;

    public static Browser atUrl(String url) {
        return new Browser(url);
    }

    public Browser(String url) {
        this.webClient = new WebClient();
        try {
            this.page = webClient.getPage(url);
        } catch (Exception e) {
            throw new ApplicationConnectionFailedException("Failed to connect to URL \"" + url + "\"", e);
        }
    }

    @Override
    public HtmlElementContext getRootElement() {
        return new HtmlRootContext(this);
    }

    public HtmlPage getPage() {
        return (HtmlPage) webClient.getCurrentWindow().getEnclosedPage();
    }
}
