package net.morher.ui.connect.api.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.morher.ui.connect.api.element.Element;

public interface ElementMethodInvocation<E extends Element, L> extends ElementMethodContext<E, L> {

    Object forwardInvocation(Object toObject) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException;

    Object forwardToDefaultImplementation() throws InvocationTargetException, InstantiationException, IllegalArgumentException, Throwable;

    <S extends Element> S getChildElement(Class<S> childElementType, L childLink);

    <S extends Element> List<S> getChildElementList(Class<S> childElementType, Iterable<L> childLinkList);

}
