package net.morher.ui.connect.api.handlers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.morher.ui.connect.api.strategy.MethodStrategy.UnknownMethodHandler;

public class ElementHandler<L> {
    private final Class<?> elementType;
    private final Map<Method, MethodHandler<L>> methodHandlers = new HashMap<>();

    public ElementHandler(Class<?> elementType) {
        this.elementType = elementType;
    }

    public Class<?> getElementType() {
        return elementType;
    }

    public void registerMethodHandler(Method method, MethodHandler<L> handler) {
        methodHandlers.put(method, handler);
    }

    public MethodHandler<L> getMethodHandler(Method method) {
        return methodHandlers.get(method);
    }

    public Collection<UnknownMethodHandler<L>> findUnhandledMethods() {
        Collection<UnknownMethodHandler<L>> unhandledMethods = new ArrayList<>();
        for (Map.Entry<Method, MethodHandler<L>> entry : methodHandlers.entrySet()) {
            MethodHandler<L> value = entry.getValue();
            if (value instanceof UnknownMethodHandler) {
                unhandledMethods.add((UnknownMethodHandler<L>) value);
            }
        }
        return unhandledMethods;
    }
}