package net.morher.ui.connect.api;

import net.morher.ui.connect.api.element.Element;
import net.morher.ui.connect.api.handlers.ElementContext;
import net.morher.ui.connect.api.handlers.ElementMethodContext;

public abstract class ApplicationUtils {

    public static ElementContext<?, ?> getElementContext(Element element) {
        if (element instanceof ElementContext) {
            return (ElementContext<?, ?>) element;
        }
        throw new IllegalArgumentException("No element found");
    }

    @SuppressWarnings("unchecked")
    public static <E, L> ElementContext<? extends E, L> findClosestSurroundingElement(ElementContext<?, L> element, Class<E> elementType) {
        ElementContext<?, L> current = element;

        while (current != null) {
            if (elementType.isAssignableFrom(current.getElementType())) {
                return (ElementContext<? extends E, L>) current;
            }

            ElementMethodContext<?, L> fromMethod = current.getFromMethod();
            current = fromMethod != null
                    ? fromMethod.getElementContext()
                    : null;
        }

        return null;
    }
}
