/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.touchicon.http.okhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.mm2d.touchicon.http.HttpResponse;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/mm2d/touchicon/http/okhttp/OkHttpResponse;", "Lnet/mm2d/touchicon/http/HttpResponse;", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "isSuccess", "", "()Z", "bodyBytes", "", "limit", "", "bodyString", "", "close", "", "header", "name", "fetchBytes", "Lokhttp3/ResponseBody;", "fetchString", "Companion", "touchicon-http-okhttp"})
public final class OkHttpResponse
implements HttpResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Response response;
    private static final int BUFFER_SIZE = 1024;

    public OkHttpResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.response = response;
    }

    public boolean isSuccess() {
        return this.response.isSuccessful();
    }

    @Nullable
    public String header(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Response.header$default((Response)this.response, (String)name, null, (int)2, null);
    }

    @Nullable
    public String bodyString(int limit) throws IOException {
        String string;
        ResponseBody responseBody = this.response.body();
        if (responseBody != null) {
            ResponseBody body = responseBody;
            boolean bl = false;
            string = limit <= 0 ? body.string() : this.fetchString(body, limit);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public byte[] bodyBytes(int limit) throws IOException {
        byte[] byArray;
        ResponseBody responseBody = this.response.body();
        if (responseBody != null) {
            ResponseBody body = responseBody;
            boolean bl = false;
            byArray = limit <= 0 ? body.bytes() : this.fetchBytes(body, limit);
        } else {
            byArray = null;
        }
        return byArray;
    }

    public void close() {
        block0: {
            ResponseBody responseBody = this.response.body();
            if (responseBody == null) break block0;
            responseBody.close();
        }
    }

    private final String fetchString(ResponseBody $this$fetchString, int limit) {
        return new String(this.fetchBytes($this$fetchString, limit), Charsets.UTF_8);
    }

    private final byte[] fetchBytes(ResponseBody $this$fetchBytes, int limit) {
        int fetchSize;
        int size;
        InputStream stream = $this$fetchBytes.byteStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int remain = limit;
        while ((size = stream.read(buffer, 0, fetchSize = Math.min(buffer.length, remain))) >= 0) {
            output.write(buffer, 0, size);
            if ((remain -= size) > 0) continue;
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"output.toByteArray()");
        return byArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/mm2d/touchicon/http/okhttp/OkHttpResponse$Companion;", "", "()V", "BUFFER_SIZE", "", "touchicon-http-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

