/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.touchicon.http.okhttp;

import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.mm2d.touchicon.http.HttpClientAdapter;
import net.mm2d.touchicon.http.HttpResponse;
import net.mm2d.touchicon.http.okhttp.OkHttpResponse;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0012*\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lnet/mm2d/touchicon/http/okhttp/OkHttpClientAdapter;", "Lnet/mm2d/touchicon/http/HttpClientAdapter;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "headers", "", "", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "userAgent", "getUserAgent", "()Ljava/lang/String;", "setUserAgent", "(Ljava/lang/String;)V", "get", "Lnet/mm2d/touchicon/http/HttpResponse;", "url", "head", "appendHeader", "Lokhttp3/Request$Builder;", "execute", "Lokhttp3/Request;", "touchicon-http-okhttp"})
public final class OkHttpClientAdapter
implements HttpClientAdapter {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private String userAgent;
    @NotNull
    private Map<String, String> headers;

    public OkHttpClientAdapter(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.userAgent = "";
        this.headers = MapsKt.emptyMap();
    }

    @NotNull
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userAgent = string;
    }

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.headers = map;
    }

    @NotNull
    public HttpResponse head(@NotNull String url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.execute(this.appendHeader(new Request.Builder().head().url(url)).build());
    }

    @NotNull
    public HttpResponse get(@NotNull String url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.execute(this.appendHeader(new Request.Builder().get().url(url)).build());
    }

    private final Request.Builder appendHeader(Request.Builder $this$appendHeader) {
        Request.Builder builder;
        Request.Builder $this$appendHeader_u24lambda_u2d0 = builder = $this$appendHeader;
        boolean bl = false;
        if (!this.getHeaders().isEmpty()) {
            $this$appendHeader_u24lambda_u2d0.headers(Headers.Companion.of(this.getHeaders()));
        }
        if (((CharSequence)this.getUserAgent()).length() > 0) {
            $this$appendHeader_u24lambda_u2d0.header("User-Agent", this.getUserAgent());
        }
        return builder;
    }

    private final HttpResponse execute(Request $this$execute) {
        return new OkHttpResponse(this.client.newCall($this$execute).execute());
    }
}

