/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.sql;

import java.util.Date;
import net.minidev.sql.SQLFormat;

public class MysqlFormat
extends SQLFormat {
    @Override
    public StringBuilder appendDateTime(StringBuilder sb, Date date) {
        if (date == null) {
            return sb.append("null");
        }
        sb.append('\"');
        sb.append(MySQL_DateTime.format(date));
        return sb.append('\"');
    }

    @Override
    public StringBuilder appendDate(StringBuilder sb, Date date) {
        if (date == null) {
            return sb.append("null");
        }
        sb.append('\"');
        sb.append(MySQL_Date.format(date));
        return sb.append('\"');
    }

    @Override
    public StringBuilder append(StringBuilder sb, String value) {
        return this.append(sb, value, '\"');
    }

    @Override
    public StringBuilder append(StringBuilder sb, byte[] data) {
        if (data == null) {
            sb.append("null");
            return sb;
        }
        char[] escaped = new char[data.length * 2 + 3];
        escaped[0] = 120;
        escaped[1] = 39;
        escaped[escaped.length - 1] = 39;
        for (int i = 0; i < data.length; ++i) {
            byte c = data[i];
            int pos = 2 + i * 2;
            escaped[pos] = hexa[c >> 4 & 0xF];
            escaped[pos + 1] = hexa[c & 0xF];
        }
        return sb.append(escaped);
    }

    public StringBuilder append(StringBuilder sb, String value, char quote) {
        if (value == null) {
            return sb.append("null");
        }
        int len = value.length();
        sb.append(quote);
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= '(' && c <= '[') {
                sb.append(c);
                continue;
            }
            if (c >= ']' && c <= '~') {
                sb.append(c);
                continue;
            }
            if (c == '\u0000') {
                sb.append("\\0");
                continue;
            }
            if (c == '\'') {
                if (quote == c) {
                    sb.append("\\'");
                    continue;
                }
                sb.append("'");
                continue;
            }
            if (c == '\"') {
                if (quote == c) {
                    sb.append("\\\"");
                    continue;
                }
                sb.append("\"");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\u001a') {
                sb.append("\\Z");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\u001a') {
                sb.append("\\Z");
                continue;
            }
            if (c >= '0' && c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.append(quote);
    }
}

