/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.minidev.sql.DatabaseTemplate;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.ObjectUtils;

public class IJdbcTemplate {
    private final NamedParameterJdbcTemplate namedParameterJdbcOperations;
    private HashMap<Class<?>, RowMapper<?>> myRowMapper;
    private DataSource ds;

    public DataSource getDataSource() {
        return this.ds;
    }

    public IJdbcTemplate(DataSource dataSource) {
        this.ds = dataSource;
        this.namedParameterJdbcOperations = new NamedParameterJdbcTemplate(dataSource);
        this.myRowMapper = new HashMap();
    }

    public <T> void registerRowMapper(Class<T> clazz, RowMapper<T> rm) {
        this.myRowMapper.put(clazz, rm);
    }

    public int update(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().update(sql) : this.getJdbcOperations().update(sql, this.getArguments(args));
    }

    public int updateNoTr(String sql) {
        Connection cnx = null;
        Statement stmt = null;
        try {
            cnx = this.ds.getConnection();
            stmt = cnx.createStatement();
            int n = stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage() + " " + sql, e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (cnx != null) {
                DatabaseTemplate.close(this.ds, cnx);
            }
        }
    }

    public int update(String sql, KeyHolder keyHolder, Object ... args) throws DataAccessException {
        int[] paramType = new int[args.length];
        int p = 0;
        for (Object obj : args) {
            if (obj == null) {
                obj = "";
            }
            int type = StatementCreatorUtils.javaTypeToSqlParameterType(obj.getClass());
            paramType[p++] = type;
        }
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sql, paramType);
        pscf.setReturnGeneratedKeys(true);
        PreparedStatementCreator psc = pscf.newPreparedStatementCreator(this.getArguments(args));
        int ret = this.getJdbcOperations().update(psc, keyHolder);
        return ret;
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.doExecuteBatchUpdate(sql, batchArgs, new int[0]);
    }

    public int queryForInt(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? ((Integer)this.getJdbcOperations().queryForObject(sql, Integer.TYPE)).intValue() : ((Integer)this.getJdbcOperations().queryForObject(sql, Integer.TYPE, this.getArguments(args))).intValue();
    }

    public String queryForString(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? (String)this.getJdbcOperations().queryForObject(sql, String.class) : (String)this.getJdbcOperations().queryForObject(sql, this.getArguments(args), String.class);
    }

    public <T> T queryForPrimitive(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForObject(sql, requiredType) : this.getJdbcOperations().queryForObject(sql, this.getArguments(args), requiredType));
    }

    public <T> T queryForObject(String sql, RowMapper<T> rm, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForObject(sql, rm) : this.getJdbcOperations().queryForObject(sql, this.getArguments(args), rm));
    }

    public <T> List<T> queryForPrimitives(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        SingleColumnRowMapper rm = new SingleColumnRowMapper(requiredType);
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().query(sql, (RowMapper)rm) : this.getJdbcOperations().query(sql, this.getArguments(args), (RowMapper)rm);
    }

    private <T> RowMapper<T> getRowMapper(Class<T> mappedClass) {
        BeanPropertyRowMapper rm = this.myRowMapper.get(mappedClass);
        if (rm == null) {
            rm = new BeanPropertyRowMapper(mappedClass);
        }
        return rm;
    }

    public <T> List<T> queryForObjects(String sql, Class<T> mappedClass, Object ... args) throws DataAccessException {
        RowMapper<T> rm = this.getRowMapper(mappedClass);
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().query(sql, rm) : this.getJdbcOperations().query(sql, this.getArguments(args), rm);
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForList(sql) : this.getJdbcOperations().queryForList(sql, this.getArguments(args));
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        try {
            RowMapper<T> rm = this.getRowMapper(requiredType);
            return (T)(ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForObject(sql, rm) : this.getJdbcOperations().queryForObject(sql, this.getArguments(args), rm));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
    }

    public <T> T queryForObjectNatif(String sql, Class<T> requiredType) throws RuntimeException {
        return (T)this.queryNative(sql, requiredType, true);
    }

    public <T> List<T> queryForObjectsNatif(String sql, Class<T> requiredType) throws RuntimeException {
        return (List)this.queryNative(sql, requiredType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object queryNative(String sql, Class<T> requiredType, boolean singleResult) throws RuntimeException {
        RuntimeException ex;
        block56: {
            Connection cnx = null;
            Statement stmt = null;
            ResultSet rs = null;
            ex = null;
            try {
                RowMapper<T> rm = this.getRowMapper(requiredType);
                cnx = this.ds.getConnection();
                stmt = cnx.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    if (singleResult) {
                        Object var9_17 = null;
                        return var9_17;
                    }
                    ArrayList arrayList = new ArrayList(0);
                    return arrayList;
                }
                Object result = rm.mapRow(rs, 0);
                if (!rs.next()) {
                    if (singleResult) {
                        Object object = result;
                        return object;
                    }
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(result);
                    ArrayList<Object> arrayList = list;
                    return arrayList;
                }
                if (singleResult) {
                    ex = new RuntimeException("Ony one Result Expected.");
                    break block56;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(result);
                int pos = 1;
                do {
                    list.add(rm.mapRow(rs, pos++));
                } while (rs.next());
                ArrayList<Object> arrayList = list;
                return arrayList;
            }
            catch (SQLException e) {
                ex = new RuntimeException(e);
            }
            catch (RuntimeException e) {
                ex = e;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
                if (cnx != null) {
                    DatabaseTemplate.close(this.ds, cnx);
                }
            }
        }
        throw ex;
    }

    public <T> List<T> query(String sql, RowMapper<T> rm, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().query(sql, rm) : this.getJdbcOperations().query(sql, this.getArguments(args), rm);
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcOperations() {
        return this.namedParameterJdbcOperations;
    }

    public JdbcOperations getJdbcOperations() {
        return this.namedParameterJdbcOperations.getJdbcOperations();
    }

    private Object[] getArguments(Object[] varArgs) {
        if (varArgs.length == 1 && varArgs[0] instanceof Object[]) {
            return (Object[])varArgs[0];
        }
        return varArgs;
    }

    private int[] doExecuteBatchUpdate(String sql, final List<Object[]> batchValues, final int[] columnTypes) {
        return this.getJdbcOperations().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = (Object[])batchValues.get(i);
                IJdbcTemplate.this.doSetStatementParameters(values, ps, columnTypes);
            }

            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    private void doSetStatementParameters(Object[] values, PreparedStatement ps, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        for (Object value : values) {
            ++colIndex;
            if (value instanceof SqlParameterValue) {
                SqlParameterValue paramValue = (SqlParameterValue)value;
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex, (SqlParameter)paramValue, (Object)paramValue.getValue());
                continue;
            }
            int colType = columnTypes == null || columnTypes.length < colIndex ? Integer.MIN_VALUE : columnTypes[colIndex - 1];
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)colIndex, (int)colType, (Object)value);
        }
    }
}

