/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import net.minidev.sql.DummyDataSource;
import net.minidev.sql.KeyHolder;
import net.minidev.util.LangUtils;
import org.springframework.jdbc.datasource.SmartDataSource;

public final class DatabaseTemplate {
    public static final boolean PEDANTIC_MODE = false;
    public static final int QUERY_TIMEOUT = 0;
    private static final int[] NO_INT = new int[0];
    private static final long[] NO_LONG = new long[0];
    private static final String[] NO_STRING = new String[0];
    private static final Object[] NO_OBJECT = new Object[0];

    private DatabaseTemplate() {
    }

    private static void handleError(String msg, Exception e) {
        throw new RuntimeException(msg, e);
    }

    private static void handleError(Exception e) {
        throw new RuntimeException(e);
    }

    private static void logError(String msg) {
    }

    public static DataSource cast(Connection cnx) {
        return new DummyDataSource(cnx);
    }

    public static int retrieveFoundRows(Statement stmt) {
        int result = -1;
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT FOUND_ROWS()");
            if (rs.next()) {
                result = rs.getInt(1);
            }
            DatabaseTemplate.close(rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(rs);
            DatabaseTemplate.handleError("Failed Executing SELECT FOUND_ROWS():" + e.getMessage(), e);
        }
        return result;
    }

    public static int retrieveInt(DataSource ds, String query) {
        Number n = (Number)DatabaseTemplate.retrieveSingleObject(ds, query);
        if (n == null) {
            return -1;
        }
        return n.intValue();
    }

    public static Integer retrieveInteger(DataSource ds, String query) {
        Number n = (Number)DatabaseTemplate.retrieveSingleObject(ds, query);
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public static Long retrieveLong(DataSource ds, String query) {
        Number n = (Number)DatabaseTemplate.retrieveSingleObject(ds, query);
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    public static Date retrieveDate(DataSource ds, String query) {
        return (Date)DatabaseTemplate.retrieveSingleObject(ds, query);
    }

    public static Date[] retrieveDates(DataSource ds, String query) {
        Object[] objs = DatabaseTemplate.retrieveObjects(ds, query);
        if (objs.length == 0) {
            return new Date[0];
        }
        Date[] result = new Date[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            result[i] = (Date)objs[i];
        }
        return result;
    }

    public static Object retrieveSingleObject(DataSource ds, String query) {
        Connection cnx = null;
        Statement stmt = null;
        ResultSet rs = null;
        Object result = null;
        try {
            cnx = ds.getConnection();
            stmt = cnx.createStatement();
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                result = rs.getObject(1);
            }
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(ds, cnx, stmt, rs);
            DatabaseTemplate.handleError(e);
        }
        return result;
    }

    public static String retrieveString(DataSource ds, String query) {
        Object n = DatabaseTemplate.retrieveSingleObject(ds, query);
        if (n == null) {
            return null;
        }
        return n.toString();
    }

    public static ArrayList<LinkedHashMap<String, Object>> retrieveDebug(DataSource ds, String query) {
        ArrayList<LinkedHashMap<String, Object>> out = new ArrayList<LinkedHashMap<String, Object>>();
        Connection cnx = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            cnx = ds.getConnection();
            stmt = cnx.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData meta = rs.getMetaData();
            int colcount = meta.getColumnCount();
            int colidMax = colcount + 1;
            while (rs.next()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (int j = 1; j < colidMax; ++j) {
                    Object v = rs.getObject(j);
                    map.put(meta.getColumnLabel(j), v);
                }
                out.add(map);
            }
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(ds, cnx, stmt, rs);
            DatabaseTemplate.handleError(e);
        }
        return out;
    }

    public static Object[] retrieveObjects(DataSource ds, String query) {
        Object[] objects = NO_OBJECT;
        Connection cnx = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            cnx = ds.getConnection();
            stmt = cnx.createStatement();
            rs = stmt.executeQuery(query);
            int colcount = rs.getMetaData().getColumnCount();
            int colidMax = colcount + 1;
            int pos = 0;
            while (rs.next()) {
                if (pos + colcount >= objects.length) {
                    int newSize = colcount * 3 + objects.length * 2;
                    objects = LangUtils.realloc((Object[])objects, (int)newSize);
                }
                for (int j = 1; j < colidMax; ++j) {
                    Object v = rs.getObject(j);
                    objects[pos++] = v;
                }
            }
            objects = LangUtils.realloc((Object[])objects, (int)pos);
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(ds, cnx, stmt, rs);
            DatabaseTemplate.handleError(e);
        }
        return objects;
    }

    public static String[] retrieveStrings(DataSource ds, String query) {
        Object[] objs = DatabaseTemplate.retrieveObjects(ds, query);
        if (objs.length == 0) {
            return NO_STRING;
        }
        String[] result = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (o == null) continue;
            result[i] = o.toString();
        }
        return result;
    }

    public static <T extends Enum<T>> T[] retrieveEnums(DataSource ds, Class<T> type, String query) {
        Object[] strs = (Enum[])LangUtils.alloc(type, (int)0);
        Connection cnx = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            int i = 0;
            cnx = ds.getConnection();
            stmt = cnx.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String v = rs.getString(1);
                if (i >= strs.length) {
                    strs = (Enum[])LangUtils.realloc((Object[])strs, (int)(10 + strs.length * 2));
                }
                strs[i++] = Enum.valueOf(type, v);
            }
            strs = (Enum[])LangUtils.realloc((Object[])strs, (int)i);
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(ds, cnx, stmt, rs);
            DatabaseTemplate.handleError(e);
        }
        return strs;
    }

    public static int[] retrieveInts(DataSource ds, String query) {
        Object[] objs = DatabaseTemplate.retrieveObjects(ds, query);
        if (objs.length == 0) {
            return NO_INT;
        }
        int[] result = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (o == null) continue;
            result[i] = ((Number)o).intValue();
        }
        return result;
    }

    public static long[] retrievelongs(DataSource ds, String query) {
        Object[] objs = DatabaseTemplate.retrieveObjects(ds, query);
        if (objs.length == 0) {
            return NO_LONG;
        }
        long[] result = new long[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (o == null) continue;
            result[i] = ((Number)o).longValue();
        }
        return result;
    }

    public static int doUpdateSilent(DataSource ds, String query) {
        try {
            return DatabaseTemplate.doUpdate(ds, query);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int doUpdate(DataSource ds, String query) {
        Connection cnx = null;
        int result = 0;
        Statement stmt = null;
        try {
            cnx = ds.getConnection();
            stmt = cnx.createStatement(1003, 1007);
            stmt.setQueryTimeout(0);
            result = stmt.executeUpdate(query);
            DatabaseTemplate.close(ds, cnx, stmt, null);
        }
        catch (SQLException e) {
            System.err.println(e);
            System.err.println(query);
            DatabaseTemplate.close(ds, cnx, stmt, null);
            if (e.getErrorCode() == 1062) {
                DatabaseTemplate.logError("duplicate Key within :" + query);
            } else {
                DatabaseTemplate.logError("doUpdate Fail on :" + query);
            }
            DatabaseTemplate.handleError(query, e);
        }
        return result;
    }

    public static int doInsertAutoIncrement(DataSource ds, String query, KeyHolder keyHolder) {
        Connection cnx = null;
        int result = -1;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            cnx = ds.getConnection();
            stmt = cnx.createStatement();
            stmt.setQueryTimeout(0);
            result = stmt.executeUpdate(query, 1);
            rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                keyHolder.key = rs.getInt(1);
            }
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            DatabaseTemplate.close(ds, cnx, stmt, rs);
            DatabaseTemplate.handleError(e);
        }
        return result;
    }

    public static void fullClose(DataSource ds, ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            Statement stmt = rs.getStatement();
            Connection cnx = stmt.getConnection();
            DatabaseTemplate.close(ds, cnx, stmt, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(DataSource ds, Connection cnx, Statement stmt, ResultSet rs) {
        DatabaseTemplate.close(rs);
        DatabaseTemplate.close(stmt);
        DatabaseTemplate.close(ds, cnx);
    }

    public static void close(DataSource ds, Connection cnx) {
        try {
            if (!(ds instanceof SmartDataSource) || ((SmartDataSource)ds).shouldClose(cnx)) {
                DatabaseTemplate.close(cnx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(Connection cnx) {
        if (cnx == null) {
            return;
        }
        try {
            cnx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

