/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */

package net.mingsoft.config;

import net.mingsoft.basic.service.CacheConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 初始化加载全部配置
 */
@Configuration("msCacheConfig")
public class CacheConfig {


    @Autowired
    private CacheConfigService cacheConfigService;

    @Bean
    public ApplicationRunner initializeCache() {
        return args -> {
            cacheConfigService.load();
        };

    }
}
