/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minestom.server.ServerProcess;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Player;
import net.minestom.server.event.player.AsyncPlayerConfigurationEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.testing.Collector;
import net.minestom.testing.Env;
import net.minestom.testing.TestConnection;

final class TestConnectionImpl
implements TestConnection {
    private final ServerProcess process;
    private final GameProfile gameProfile;
    private final PlayerConnectionImpl playerConnection = new PlayerConnectionImpl();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final List<IncomingCollector<ServerPacket>> incomingTrackers = new CopyOnWriteArrayList<IncomingCollector<ServerPacket>>();

    TestConnectionImpl(Env env, GameProfile gameProfile) {
        this.process = env.process();
        this.gameProfile = gameProfile;
    }

    @Override
    public Player connect(Instance instance, Pos pos) {
        if (!this.connected.compareAndSet(false, true)) {
            throw new IllegalStateException("Already connected");
        }
        Player player = this.process.connection().createPlayer((PlayerConnection)this.playerConnection, this.gameProfile);
        player.eventNode().addListener(AsyncPlayerConfigurationEvent.class, event -> {
            event.setSpawningInstance(instance);
            event.getPlayer().setRespawnPoint(pos);
        });
        CompletableFuture future = new CompletableFuture();
        Thread.startVirtualThread(() -> {
            this.process.connection().doConfiguration(player, false);
            this.process.connection().transitionConfigToPlay(player);
            future.complete(player);
        });
        future.join();
        this.playerConnection.setConnectionState(ConnectionState.PLAY);
        this.process.connection().updateWaitingPlayers();
        return player;
    }

    @Override
    public <T extends ServerPacket> Collector<T> trackIncoming(Class<T> type) {
        IncomingCollector<T> tracker = new IncomingCollector<T>(type);
        this.incomingTrackers.add((IncomingCollector)IncomingCollector.class.cast(tracker));
        return tracker;
    }

    final class PlayerConnectionImpl
    extends PlayerConnection {
        private boolean online = true;

        PlayerConnectionImpl() {
        }

        public void sendPacket(SendablePacket packet) {
            ServerPacket serverPacket = this.extractPacket(packet);
            for (IncomingCollector<ServerPacket> tracker : TestConnectionImpl.this.incomingTrackers) {
                if (!tracker.type.isAssignableFrom(serverPacket.getClass())) continue;
                tracker.packets.add(serverPacket);
            }
        }

        private ServerPacket extractPacket(SendablePacket packet) {
            if (!(packet instanceof ServerPacket)) {
                return SendablePacket.extractServerPacket((ConnectionState)this.getConnectionState(), (SendablePacket)packet);
            }
            ServerPacket serverPacket = (ServerPacket)packet;
            Player player = this.getPlayer();
            if (player == null) {
                return serverPacket;
            }
            if (MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION && serverPacket instanceof ServerPacket.ComponentHolding) {
                serverPacket = (ServerPacket)((ServerPacket.ComponentHolding)serverPacket).copyWithOperator(component -> GlobalTranslator.render((Component)component, (Locale)Objects.requireNonNullElseGet(player.getLocale(), MinestomAdventure::getDefaultLocale)));
            }
            return serverPacket;
        }

        public SocketAddress getRemoteAddress() {
            return new InetSocketAddress("localhost", 25565);
        }

        public boolean isOnline() {
            return this.online;
        }

        public void disconnect() {
            this.online = false;
        }
    }

    final class IncomingCollector<T extends ServerPacket>
    implements Collector<T> {
        private final Class<T> type;
        private final List<T> packets = new CopyOnWriteArrayList<T>();

        public IncomingCollector(Class<T> type) {
            this.type = type;
        }

        @Override
        public List<T> collect() {
            TestConnectionImpl.this.incomingTrackers.remove(this);
            return List.copyOf(this.packets);
        }
    }

    static final class TestPlayerImpl
    extends Player {
        public TestPlayerImpl(PlayerConnection playerConnection, GameProfile gameProfile) {
            super(playerConnection, gameProfile);
        }

        public void sendChunk(Chunk chunk) {
            this.sendPacket(chunk.getFullDataPacket());
        }
    }
}

