/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing.util;

import java.util.HashMap;
import java.util.Map;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class MockBlockGetter
implements Block.Getter,
Block.Setter {
    private final Map<Vec, Block> blocks = new HashMap<Vec, Block>();
    private final Block defaultBlock;

    @NotNull
    public static MockBlockGetter empty() {
        return new MockBlockGetter(Map.of(), Block.AIR);
    }

    @NotNull
    public static MockBlockGetter single(@NotNull Block block) {
        return new MockBlockGetter(Map.of(Vec.ZERO, block), Block.AIR);
    }

    @NotNull
    public static MockBlockGetter all(@NotNull Block block) {
        return new MockBlockGetter(Map.of(), block);
    }

    private MockBlockGetter(Map<Vec, Block> blocks, Block defaultBlock) {
        blocks.forEach((pos, block) -> this.blocks.put(new Vec((double)pos.blockX(), (double)pos.blockY(), (double)pos.blockZ()), (Block)block));
        this.defaultBlock = defaultBlock;
    }

    public @UnknownNullability Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        return this.blocks.getOrDefault(new Vec((double)x, (double)y, (double)z), this.defaultBlock);
    }

    public void setBlock(int x, int y, int z, @NotNull Block block) {
        this.blocks.put(new Vec((double)x, (double)y, (double)z), block);
    }
}

