/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import net.minestom.server.MinecraftServer;
import net.minestom.testing.Env;
import net.minestom.testing.EnvImpl;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.Extensions;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.support.TypeBasedParameterResolver;

@Extensions(value={@ExtendWith(value={EnvParameterResolver.class}), @ExtendWith(value={EnvBefore.class}), @ExtendWith(value={EnvCleaner.class})})
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface EnvTest {

    public static final class EnvParameterResolver
    extends TypeBasedParameterResolver<Env> {
        public Env resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return new EnvImpl(MinecraftServer.updateProcess());
        }
    }

    public static final class EnvCleaner
    implements InvocationInterceptor {
        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            invocation.proceed();
            Env env = null;
            for (Object arg : invocationContext.getArguments()) {
                if (!(arg instanceof Env)) continue;
                env = (Env)arg;
                break;
            }
            if (env instanceof EnvImpl) {
                EnvImpl envImpl = (EnvImpl)env;
                envImpl.cleanup();
            }
        }
    }

    public static final class EnvBefore
    implements BeforeEachCallback {
        public void beforeEach(ExtensionContext context) {
            System.setProperty("minestom.viewable-packet", "false");
        }
    }
}

