/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.testing;

import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public interface Collector<T> {
    @NotNull
    public @NotNull List<@NotNull T> collect();

    default public <P extends T> void assertSingle(@NotNull Class<P> type, @NotNull Consumer<P> consumer) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)1, (int)elements.size(), (String)("Expected 1 element, got " + String.valueOf(elements)));
        T element = elements.get(0);
        Assertions.assertInstanceOf(type, element, (String)("Expected type " + type.getSimpleName() + ", got " + element.getClass().getSimpleName()));
        consumer.accept(element);
    }

    default public void assertSingle(@NotNull Consumer<T> consumer) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)1, (int)elements.size(), (String)("Expected 1 element, got " + String.valueOf(elements)));
        consumer.accept(elements.get(0));
    }

    default public void assertCount(int count) {
        List<T> elements = this.collect();
        Assertions.assertEquals((int)count, (int)elements.size(), (String)("Expected " + count + " element(s), got " + elements.size() + ": " + String.valueOf(elements)));
    }

    default public void assertSingle() {
        this.assertCount(1);
    }

    default public void assertEmpty() {
        this.assertCount(0);
    }
}

