/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import it.unimi.dsi.fastutil.HashCommon;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Supplier;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.SchedulerImpl;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;
import org.jetbrains.annotations.NotNull;

final class TaskImpl
implements Task {
    private static final VarHandle PARKED;
    private final int id;
    @NotNull
    private final Supplier<TaskSchedule> task;
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final SchedulerImpl owner;
    volatile boolean alive;
    volatile boolean parked;

    TaskImpl(int id, @NotNull Supplier<TaskSchedule> task, @NotNull ExecutionType executionType, @NotNull SchedulerImpl owner) {
        this.id = id;
        this.task = task;
        this.executionType = executionType;
        this.owner = owner;
        this.alive = true;
    }

    @Override
    public void unpark() {
        this.owner.unparkTask(this);
    }

    boolean tryUnpark() {
        return PARKED.compareAndSet(this, true, false);
    }

    @Override
    public boolean isParked() {
        return this.parked;
    }

    @Override
    public void cancel() {
        this.alive = false;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public int id() {
        return this.id;
    }

    @NotNull
    public Supplier<TaskSchedule> task() {
        return this.task;
    }

    @Override
    @NotNull
    public ExecutionType executionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public SchedulerImpl owner() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TaskImpl that = (TaskImpl)obj;
        return this.id == that.id;
    }

    public int hashCode() {
        return HashCommon.murmurHash3((int)this.id);
    }

    public String toString() {
        return "TaskImpl[id=" + this.id + ", task=" + this.task + ", executionType=" + this.executionType + ", owner=" + this.owner + "]";
    }

    static {
        try {
            PARKED = MethodHandles.lookup().findVarHandle(TaskImpl.class, "parked", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

