/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.statistic.StatisticCategory;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record StatisticsPacket(@NotNull List<Statistic> statistics) implements ServerPacket
{
    public StatisticsPacket(@NotNull List<Statistic> statistics) {
        statistics = List.copyOf(statistics);
    }

    public StatisticsPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(Statistic::new));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.statistics);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.STATISTICS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    public record Statistic(@NotNull StatisticCategory category, int statisticId, int value) implements NetworkBuffer.Writer
    {
        public Statistic(@NotNull NetworkBuffer reader) {
            this(reader.readEnum(StatisticCategory.class), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.category.ordinal());
            writer.write(NetworkBuffer.VAR_INT, this.statisticId);
            writer.write(NetworkBuffer.VAR_INT, this.value);
        }
    }
}

