/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.network.packet.server.play.data.DeathLocation;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record JoinGamePacket(int entityId, boolean isHardcore, List<String> worlds, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean doLimitedCrafting, String dimensionType, String world, long hashedSeed, GameMode gameMode, GameMode previousGameMode, boolean isDebug, boolean isFlat, DeathLocation deathLocation, int portalCooldown) implements ServerPacket
{
    public JoinGamePacket {
        worlds = List.copyOf(worlds);
    }

    public JoinGamePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.BOOLEAN), reader.readCollection(NetworkBuffer.STRING), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), JoinGamePacket.getNullableGameMode(reader.read(NetworkBuffer.BYTE)), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.DEATH_LOCATION), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.entityId);
        writer.write(NetworkBuffer.BOOLEAN, this.isHardcore);
        writer.writeCollection(NetworkBuffer.STRING, this.worlds);
        writer.write(NetworkBuffer.VAR_INT, this.maxPlayers);
        writer.write(NetworkBuffer.VAR_INT, this.viewDistance);
        writer.write(NetworkBuffer.VAR_INT, this.simulationDistance);
        writer.write(NetworkBuffer.BOOLEAN, this.reducedDebugInfo);
        writer.write(NetworkBuffer.BOOLEAN, this.enableRespawnScreen);
        writer.write(NetworkBuffer.BOOLEAN, this.doLimitedCrafting);
        writer.write(NetworkBuffer.STRING, this.dimensionType);
        writer.write(NetworkBuffer.STRING, this.world);
        writer.write(NetworkBuffer.LONG, this.hashedSeed);
        writer.write(NetworkBuffer.BYTE, this.gameMode.id());
        if (this.previousGameMode != null) {
            writer.write(NetworkBuffer.BYTE, this.previousGameMode.id());
        } else {
            writer.write(NetworkBuffer.BYTE, (byte)-1);
        }
        writer.write(NetworkBuffer.BOOLEAN, this.isDebug);
        writer.write(NetworkBuffer.BOOLEAN, this.isFlat);
        writer.write(NetworkBuffer.DEATH_LOCATION, this.deathLocation);
        writer.write(NetworkBuffer.VAR_INT, this.portalCooldown);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.JOIN_GAME;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Nullable
    private static GameMode getNullableGameMode(byte id) {
        return id == -1 ? null : GameMode.fromId(id);
    }
}

