/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EntityPositionPacket(int entityId, short deltaX, short deltaY, short deltaZ, boolean onGround) implements ServerPacket
{
    public EntityPositionPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.SHORT, this.deltaX);
        writer.write(NetworkBuffer.SHORT, this.deltaY);
        writer.write(NetworkBuffer.SHORT, this.deltaZ);
        writer.write(NetworkBuffer.BOOLEAN, this.onGround);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ENTITY_POSITION;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @NotNull
    public static EntityPositionPacket getPacket(int entityId, @NotNull Pos newPosition, @NotNull Pos oldPosition, boolean onGround) {
        short deltaX = (short)((newPosition.x() * 32.0 - oldPosition.x() * 32.0) * 128.0);
        short deltaY = (short)((newPosition.y() * 32.0 - oldPosition.y() * 32.0) * 128.0);
        short deltaZ = (short)((newPosition.z() * 32.0 - oldPosition.z() * 32.0) * 128.0);
        return new EntityPositionPacket(entityId, deltaX, deltaY, deltaZ, onGround);
    }
}

