/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.configuration;

import java.util.Set;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record UpdateEnabledFeaturesPacket(@NotNull Set<NamespaceID> features) implements ServerPacket
{
    public UpdateEnabledFeaturesPacket(@NotNull NetworkBuffer buffer) {
        this(Set.copyOf(buffer.readCollection(b -> NamespaceID.from(b.read(NetworkBuffer.STRING)))));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.features, (b, feature) -> b.write(NetworkBuffer.STRING, feature.asString()));
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.CONFIGURATION -> 8;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.CONFIGURATION);
        };
    }
}

