/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record PingPacket(int id) implements ServerPacket
{
    public PingPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.id);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.CONFIGURATION -> 4;
            case ConnectionState.PLAY -> ServerPacketIdentifier.PING;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.CONFIGURATION, ConnectionState.PLAY);
        };
    }
}

