/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public final class BiomeManager {
    private final Map<Integer, Biome> biomes = new ConcurrentHashMap<Integer, Biome>();
    private final Map<NamespaceID, Biome> biomesByName = new ConcurrentHashMap<NamespaceID, Biome>();
    private final Map<NamespaceID, Integer> idMappings = new ConcurrentHashMap<NamespaceID, Integer>();
    private final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    private NBTCompound nbtCache = null;

    public BiomeManager() {
        this.addBiome(BiomeImpl.get("minecraft:plains"));
    }

    public void loadVanillaBiomes() {
        for (BiomeImpl biome : BiomeImpl.values()) {
            if (this.getByName(biome.namespace()) != null) continue;
            this.addBiome(biome);
        }
    }

    public void addBiome(@NotNull Biome biome) {
        Check.stateCondition(this.getByName(biome.namespace()) != null, "The biome " + biome.namespace() + " has already been registered");
        int id = this.ID_COUNTER.getAndIncrement();
        this.biomes.put(id, biome);
        this.biomesByName.put(biome.namespace(), biome);
        this.idMappings.put(biome.namespace(), id);
        this.nbtCache = null;
    }

    public void removeBiome(@NotNull Biome biome) {
        Integer id = this.idMappings.get(biome.namespace());
        if (id != null) {
            this.biomes.remove(id);
            this.biomesByName.remove(biome.namespace());
            this.idMappings.remove(biome.namespace());
            this.nbtCache = null;
        }
    }

    public Collection<Biome> unmodifiableCollection() {
        return Collections.unmodifiableCollection(this.biomes.values());
    }

    @Nullable
    public Biome getById(int id) {
        return this.biomes.get(id);
    }

    @Nullable
    public Biome getByName(@NotNull NamespaceID namespaceID) {
        return this.biomesByName.get(namespaceID);
    }

    @Nullable
    public Biome getByName(@NotNull String namespaceID) {
        NamespaceID namespace = NamespaceID.from(namespaceID);
        return this.getByName(namespace);
    }

    @NotNull
    public NBTCompound toNBT() {
        if (this.nbtCache != null) {
            return this.nbtCache;
        }
        this.nbtCache = NBT.Compound(Map.of("type", NBT.String((String)"minecraft:worldgen/biome"), "value", NBT.List((NBTType)NBTType.TAG_Compound, this.biomes.values().stream().map(biome -> NBT.Compound(Map.of("id", NBT.Int((int)this.getId((Biome)biome)), "name", NBT.String((String)biome.namespace().toString()), "element", biome.toNbt()))).toList())));
        return this.nbtCache;
    }

    public int getId(Biome biome) {
        return this.idMappings.getOrDefault(biome.namespace(), -1);
    }
}

