/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record PlayerListHeaderAndFooterPacket(@NotNull Component header, @NotNull Component footer) implements ComponentHoldingServerPacket
{
    public PlayerListHeaderAndFooterPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.COMPONENT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.COMPONENT, this.header);
        writer.write(NetworkBuffer.COMPONENT, this.footer);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return List.of(this.header, this.footer);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new PlayerListHeaderAndFooterPacket((Component)operator.apply(this.header), (Component)operator.apply(this.footer));
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.PLAYER_LIST_HEADER_AND_FOOTER;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

