/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.crypto.FilterMask;
import net.minestom.server.crypto.SignedMessageBody;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerChatMessagePacket(UUID sender, int index, byte @Nullable [] signature, @NotNull SignedMessageBody.Packed messageBody, @Nullable Component unsignedContent, FilterMask filterMask, int msgTypeId, Component msgTypeName, @Nullable Component msgTypeTarget) implements ComponentHoldingServerPacket
{
    public PlayerChatMessagePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.UUID), reader.read(NetworkBuffer.VAR_INT), reader.readOptional(r -> r.readBytes(256)), new SignedMessageBody.Packed(reader), reader.readOptional(NetworkBuffer.COMPONENT), new FilterMask(reader), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.COMPONENT), reader.readOptional(NetworkBuffer.COMPONENT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.UUID, this.sender);
        writer.write(NetworkBuffer.VAR_INT, this.index);
        writer.writeOptional(NetworkBuffer.RAW_BYTES, this.signature);
        writer.write(this.messageBody);
        writer.writeOptional(NetworkBuffer.COMPONENT, this.unsignedContent);
        writer.write(this.filterMask);
        writer.write(NetworkBuffer.VAR_INT, this.msgTypeId);
        writer.write(NetworkBuffer.COMPONENT, this.msgTypeName);
        writer.writeOptional(NetworkBuffer.COMPONENT, this.msgTypeTarget);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.PLAYER_CHAT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(this.msgTypeName);
        if (this.unsignedContent != null) {
            list.add(this.unsignedContent);
        }
        if (this.msgTypeTarget != null) {
            list.add(this.msgTypeTarget);
        }
        return List.copyOf(list);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new PlayerChatMessagePacket(this.sender, this.index, this.signature, this.messageBody, (Component)operator.apply(this.unsignedContent), this.filterMask, this.msgTypeId, (Component)operator.apply(this.msgTypeName), (Component)operator.apply(this.msgTypeTarget));
    }
}

