/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record OpenSignEditorPacket(@NotNull Point position, boolean isFrontText) implements ServerPacket
{
    public OpenSignEditorPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BLOCK_POSITION, this.position);
        writer.write(NetworkBuffer.BOOLEAN, this.isFrontText);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.OPEN_SIGN_EDITOR;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

