/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EntityTeleportPacket(int entityId, Pos position, boolean onGround) implements ServerPacket
{
    public EntityTeleportPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), new Pos(reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.DOUBLE, this.position.x());
        writer.write(NetworkBuffer.DOUBLE, this.position.y());
        writer.write(NetworkBuffer.DOUBLE, this.position.z());
        writer.write(NetworkBuffer.BYTE, (byte)(this.position.yaw() * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BYTE, (byte)(this.position.pitch() * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BOOLEAN, this.onGround);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.ENTITY_TELEPORT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

