/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record EffectPacket(int effectId, Point position, int data, boolean disableRelativeVolume) implements ServerPacket
{
    public EffectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.effectId);
        writer.write(NetworkBuffer.BLOCK_POSITION, this.position);
        writer.write(NetworkBuffer.INT, this.data);
        writer.write(NetworkBuffer.BOOLEAN, this.disableRelativeVolume);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.EFFECT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

